import 'dart:io';
import 'dart:convert';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:firebase_core/firebase_core.dart';
import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter_local_notifications/flutter_local_notifications.dart';
import 'package:provider/provider.dart';
import 'package:pulse/SplashScreen.dart';
import 'package:pulse/Notifier/auth_provider.dart';
import 'package:pulse/Notifier/theme_provider.dart';
import 'package:pulse/Notifier/ProfileProvider.dart';
import 'package:pulse/Notifier/webProvider.dart';
import 'package:flutter_inappwebview/flutter_inappwebview.dart';
import 'package:pulse/utils/SharedpreferencesService.dart';
import 'Screens/home_screen.dart';

//  Needed to navigate outside BuildContext
final GlobalKey<NavigatorState> navigatorKey = GlobalKey<NavigatorState>();
// Initialize the notification plugin
final FlutterLocalNotificationsPlugin flutterLocalNotificationsPlugin =
FlutterLocalNotificationsPlugin();

// Handle background notifications
Future<void> _firebaseMessagingBackgroundHandler(RemoteMessage message) async {
  if (Firebase.apps.isEmpty) {
    await Firebase.initializeApp();
  }
  print("📬 Background message: ${message.messageId}");
}

Future<void> main() async {
  WidgetsFlutterBinding.ensureInitialized();

  //  Initialize Firebase safely
  try {
    if (Firebase.apps.isEmpty) {
      await Firebase.initializeApp(
        options: const FirebaseOptions(
          apiKey: "2f663c764bb77355c82d30b2068b15427363ccfd",
          appId: "1:207322820833:android:82516ed462f6ae6e4447a0",
          messagingSenderId: "207322820833",
          projectId: "pulse-5cf9a",
        ),
      );
      debugPrint(" Firebase initialized.");
    } else {
      Firebase.app(); // existing instance
      debugPrint("⚡ Firebase already initialized, reusing instance.");
    }
  } catch (e) {
    debugPrint("❌ Firebase init error: $e");
  }

  //  Setup local notifications
  const AndroidInitializationSettings initializationSettingsAndroid =
  AndroidInitializationSettings('@mipmap/ic_launcher');
  const InitializationSettings initializationSettings =
  InitializationSettings(android: initializationSettingsAndroid);
  await flutterLocalNotificationsPlugin.initialize(initializationSettings);

  //  Local notifications setup
  const AndroidInitializationSettings initSettingsAndroid =
  AndroidInitializationSettings('@mipmap/ic_launcher');
  const InitializationSettings initSettings =
  InitializationSettings(android: initSettingsAndroid);
  await flutterLocalNotificationsPlugin.initialize(
    initSettings,
    onDidReceiveNotificationResponse: (NotificationResponse response) {
      if (response.payload != null) {
        final data = jsonDecode(response.payload!);
        NotificationHandler.handle(data);
      }
    },
  );

  //  Setup FCM
  FirebaseMessaging messaging = FirebaseMessaging.instance;
  await messaging.requestPermission(alert: true, badge: true, sound: true);


  // String? token = await messaging.getToken();
  // print("🔥 FCM Token: $token");

  // Background handler
  FirebaseMessaging.onBackgroundMessage(_firebaseMessagingBackgroundHandler);

  // Foreground notification
  FirebaseMessaging.onMessage.listen((RemoteMessage message) async {
    print("💬 Foreground message: ${message.notification?.title}");

    RemoteNotification? notification = message.notification;
    AndroidNotification? android = message.notification?.android;

    if (notification != null && android != null) {
      flutterLocalNotificationsPlugin.show(
        notification.hashCode,
        notification.title,
        notification.body,
        const NotificationDetails(
          android: AndroidNotificationDetails(
            'pulse_channel', // channel id
            'Pulse Notifications', // channel name
            importance: Importance.max,
            priority: Priority.high,
          ),
        ),
        payload: jsonEncode(message.data),
      );
    }
  });

  // notification while app is in background
  FirebaseMessaging.onMessageOpenedApp.listen((RemoteMessage message) {
    print("🔥🔥🔥🔥🔥 Notification clicked: ${message.data}");
    NotificationHandler.handle(message.data);
  });

  InAppWebViewController.setWebContentsDebuggingEnabled(true);

  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MultiProvider(
      providers: [
        ChangeNotifierProvider<AuthProvider>(create: (_) => AuthProvider()),
        ChangeNotifierProvider<ThemeProvider>(create: (_) => ThemeProvider()),
        ChangeNotifierProvider<ProfileProvider>(create: (_) => ProfileProvider()),
        ChangeNotifierProvider<WebErpProvider>(create: (_) => WebErpProvider()),
      ],
      child: Consumer<ThemeProvider>(
        builder: (context, themeProvider, child) {
          return MaterialApp(
            debugShowCheckedModeBanner: false,
            title: 'Web Grid Pulse',
            navigatorKey: navigatorKey,
            theme: themeProvider.isDark
                ? ThemeData.dark()
                : ThemeData.light().copyWith(
              scaffoldBackgroundColor: const Color(0xFFF5F8FC),
            ),
            home: const SplashScreen(),
          );
        },
      ),
    );
  }
}


class NotificationHandler {
  static Future<void> handle(Map<String, dynamic> data) async {
    final type = data['type'];
    final value = data['type_value'];
    final notifId = data['notification_id'];
    final prefs = SharedPreferencesService.instance;
    final sessionId = await prefs.getString("sessionId");
    final staffId = await prefs.getString("staffId");
    debugPrint("✅ Direct session restore  $sessionId");
    debugPrint("✅ Direct staff restore  $staffId");

    debugPrint("🔗 Handling Notification:");
    debugPrint("type=$type, value=$value, id=$notifId");

    // Decide what to do based on the type
    if (type == 'url' && value != null) {
      navigatorKey.currentState?.push(
        MaterialPageRoute(
          builder: (_) => HomeScreen(
            sessionId: sessionId.toString(),
            staffId: staffId.toString(),
            notificationUrl: value,
          ),
        ),
      );
    }
  }
}

