import 'package:firebase_messaging/firebase_messaging.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:pulse/Models/profileResponse.dart';
import '../Services/api_calling.dart';

class ProfileProvider extends ChangeNotifier {
  bool _isLoading = false;
  ProfileResponse? _profileResponse;
  String? _errorMessage;

  // Getters
  bool get isLoading => _isLoading;
  ProfileResponse? get profileResponse => _profileResponse;
  String? get errorMessage => _errorMessage;

  // Convenient getters
  String? get error => _profileResponse?.error;
  String? get message => _profileResponse?.message;
  String? get sessionExists => _profileResponse?.sessionExists;
  StaffDetails? get staffDetails => _profileResponse?.staffDetails;

  String? get email => _profileResponse?.staffDetails?.email;
  String? get firstname => _profileResponse?.staffDetails?.firstname;
  String? get lastname => _profileResponse?.staffDetails?.lastname;
  String? get smallProfilePic => _profileResponse?.staffDetails?.smallProfilePic;
  String? get profilePic => _profileResponse?.staffDetails?.profilePic;

  /// Fetch profile API
  Future<void> fetchProfile({
    required BuildContext context,
    required String csrfToken,
    required String sessionId,
    required String staffId,
    String isApp = "1",
  }) async {
    try {
      _isLoading = true;
      _errorMessage = null;
      _profileResponse = null;
      notifyListeners();
      String? fcmToken = await FirebaseMessaging.instance.getToken();
      final data = await ApiService.fetchProfile(
        csrfToken: csrfToken,
        sessionId: sessionId,
        staffId: staffId,
        token:  fcmToken.toString() ?? "",
        isApp: isApp,
      );

      if (data != null) {
        _profileResponse = data;

        if (_profileResponse?.error == "0") {
          debugPrint("✅ Profile fetched: ${_profileResponse?.toJson()}");
        } else {
          _errorMessage = _profileResponse?.message ?? "Failed to fetch profile";
          debugPrint("⚠️ Profile error: $_errorMessage");
        }
      } else {
        _errorMessage = "No response from server";
        debugPrint("⚠️ $_errorMessage");
      }
    } catch (e) {
      _errorMessage = "❌ Exception: $e";
      debugPrint(_errorMessage);
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  /// Reset state
  void reset() {
    _isLoading = false;
    _profileResponse = null;
    _errorMessage = null;
    notifyListeners();
  }
}
