class ProfileResponse {
  String? error;
  StaffDetails? staffDetails;
  String? sessionExists;
  String? message;

  ProfileResponse(
      {this.error, this.staffDetails, this.sessionExists, this.message});

  ProfileResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    staffDetails = json['staff_details'] != null
        ? new StaffDetails.fromJson(json['staff_details'])
        : null;
    sessionExists = json['session_exists'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.staffDetails != null) {
      data['staff_details'] = this.staffDetails!.toJson();
    }
    data['session_exists'] = this.sessionExists;
    data['message'] = this.message;
    return data;
  }
}

class StaffDetails {
  String? email;
  String? firstname;
  String? lastname;
  String? smallProfilePic;
  String? profilePic;

  StaffDetails(
      {this.email,
        this.firstname,
        this.lastname,
        this.smallProfilePic,
        this.profilePic});

  StaffDetails.fromJson(Map<String, dynamic> json) {
    email = json['email'];
    firstname = json['firstname'];
    lastname = json['lastname'];
    smallProfilePic = json['small_profile_pic'];
    profilePic = json['profile_pic'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['email'] = this.email;
    data['firstname'] = this.firstname;
    data['lastname'] = this.lastname;
    data['small_profile_pic'] = this.smallProfilePic;
    data['profile_pic'] = this.profilePic;
    return data;
  }
}
