class WebErpResponse {
  final String? html;

  WebErpResponse({this.html});

  // Simple factory that just stores the HTML
  factory WebErpResponse.fromJson(dynamic data) {
    return WebErpResponse(html: data is String ? data : null);
  }

  @override
  String toString() {
    return "WebErpResponse(html: ${html != null ? '${html!.length} characters' : 'null'})";
  }

  // Helper method to check if HTML contains specific content
  bool contains(String text) {
    return html?.toLowerCase().contains(text.toLowerCase()) ?? false;
  }

  // Check if it's an error response
  bool get isError => html?.startsWith("Error:") ?? false;

  // Check if session is valid (based on HTML content)
  bool get isSessionValid {
    if (html == null) return false;
    return !html!.toLowerCase().contains('login');
  }
}