import 'package:flutter/material.dart';
import 'package:flutter/services.dart';

class CustomSnackBar {
  static void show({
    required BuildContext context,
    required String message,
    String? title,
    IconData? icon,
    Color backgroundColor = const Color(0xFF324563),
    Duration duration = const Duration(seconds: 4),
  }) {
    HapticFeedback.lightImpact();
    ScaffoldMessenger.of(context).showSnackBar(
      SnackBar(
        backgroundColor: Colors.transparent,
        elevation: 0,
        duration: duration,
        behavior: SnackBarBehavior.floating,
        content: Container(
          padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 8),
          decoration: BoxDecoration(
            color: backgroundColor,
            borderRadius: BorderRadius.circular(10),
            boxShadow: [
              BoxShadow(
                color: Colors.white.withOpacity(0.3),
                blurRadius: 8,
                offset: const Offset(0, 4),
              ),
            ],
            gradient: LinearGradient(
              begin: Alignment.topLeft,
              end: Alignment.bottomRight,
              colors: [
                backgroundColor,
                Color(0xFF334155), // Slightly lighter shade
              ],
            ),
          ),
          child: Row(
            children: [
              // Icon Section
              Container(
                padding: const EdgeInsets.all(8),
                decoration: BoxDecoration(
                  color: Colors.white.withOpacity(0.1),
                  shape: BoxShape.circle,
                ),
                child: Icon(
                  icon ?? Icons.info_outline,
                  color: Colors.white,
                  size: 20,
                ),
              ),

              const SizedBox(width: 12),

              // Content Section
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisSize: MainAxisSize.min,
                  children: [
                    if (title != null) ...[
                      Text(
                        title,
                        style: const TextStyle(
                          color: Colors.white,
                          fontWeight: FontWeight.bold,
                          fontSize: 14,
                        ),
                      ),
                      const SizedBox(height: 2),
                    ],
                    Text(
                      message,
                      style: const TextStyle(
                        color: Colors.white,
                        fontSize: 13,
                      ),
                      maxLines: 2,
                      overflow: TextOverflow.ellipsis,
                    ),
                  ],
                ),
              ),

              // Close Button
              IconButton(
                icon: Icon(Icons.close, color: Colors.white.withOpacity(0.7), size: 18),
                onPressed: () {
                  ScaffoldMessenger.of(context).hideCurrentSnackBar();
                },
                padding: EdgeInsets.zero,
                constraints: const BoxConstraints(),
              ),
            ],
          ),
        ),
      ),
    );
  }

  // Predefined styles for different message types
  static void showSuccess(BuildContext context, String message) {
    show(
      context: context,
      message: message,
      title: "Success",
      icon: Icons.check_circle,
      backgroundColor: Colors.green, // Green for success
    );
  }

  static void showError(BuildContext context, String message) {
    show(
      context: context,
      message: message,
      title: "Error",
      icon: Icons.error_outline,
      backgroundColor: const Color(0xFFdc2626), // Red for errors
    );
  }

  static void showWarning(BuildContext context, String message) {
    show(
      context: context,
      message: message,
      title: "Warning",
      icon: Icons.warning_amber,
      backgroundColor: const Color(0xFFd97706), // Amber for warnings
    );
  }

  static void showInfo(BuildContext context, String message) {
    show(
      context: context,
      message: message,
      title: "Info",
      icon: Icons.info_outline,
      backgroundColor: const Color(0xFF1e293b),
    );
  }
}