import 'package:flutter/material.dart';
import 'package:pulse/Screens/home_screen.dart';
import 'package:pulse/utils/AppColors.dart';
import 'package:pulse/utils/SharedpreferencesService.dart';
import 'package:shared_preferences/shared_preferences.dart';


class SettingsScreen extends StatefulWidget {
  const SettingsScreen({Key? key}) : super(key: key);

  @override
  State<SettingsScreen> createState() => _SettingsScreenState();
}

class _SettingsScreenState extends State<SettingsScreen> {
  final prefs = SharedPreferencesService.instance;
  bool _autoLoginEnabled = false;

  @override
  void initState() {
    super.initState();
    _loadAutoLoginPreference();
  }

  Future<void> _loadAutoLoginPreference() async {
    final remember = await prefs.getBool("remember");
    setState(() {
      _autoLoginEnabled = remember ?? false; // default to false if null
    });
  }


  Future<void> _updateAutoLoginPreference(bool value) async {
    await prefs.saveBool("remember", value);
    setState(() {
      _autoLoginEnabled = value;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: AppColors.backgroundGradient1,
        title: Row(
          children: [
            InkResponse(
              onTap: () => Navigator.pop(context, true),
              child: Icon(
                Icons.arrow_back,
                color: Colors.white,
                size: 35,
              ),
            ),
            const SizedBox(width: 15),
            Text(
              "Settings",
              style: TextStyle(
                fontSize: 22,
                fontWeight: FontWeight.bold,
                color: AppColors.textPrimary,
              ),
            ),
          ],
        ),
      ),
      body: Container(
        decoration: const BoxDecoration(
          gradient: LinearGradient(
            colors: [
              AppColors.backgroundGradient1,
              AppColors.backgroundGradientMid,
              AppColors.backgroundGradientBottom,
            ],
            begin: Alignment.topCenter,
            end: Alignment.bottomCenter,
          ),
        ),
        padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 30),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            const Text(
              "Preference",
              style: TextStyle(
                fontSize: 18,
                fontWeight: FontWeight.normal,
                color: AppColors.textSecondary,
              ),
            ),
            const SizedBox(height: 20),
            Container(
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 8),
              decoration: BoxDecoration(
                color: AppColors.cardColor,
                borderRadius: BorderRadius.circular(12),
              ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  const Text(
                    "Auto Login",
                    style: TextStyle(
                      fontSize: 16,
                      color: AppColors.textPrimary,
                    ),
                  ),
                  Switch(
                    value: _autoLoginEnabled,
                    onChanged: _updateAutoLoginPreference,
                    activeColor: AppColors.accentColor,
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
