import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:provider/provider.dart';

import '../Notifiers/generatorDetailsProvider.dart';
import '../Utility/AppColors.dart';

class AmcQuotationListScreen extends StatefulWidget {
  final accId;
  final sessionId;
  final genid;
  const AmcQuotationListScreen({super.key,required this.accId,required this.sessionId,required this.genid});

  @override
  State<AmcQuotationListScreen> createState() => _AmcQuotationListScreenState();
}

class _AmcQuotationListScreenState extends State<AmcQuotationListScreen> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<Generatordetailsprovider>(
        context,
        listen: false,
      );
      provider.fetchAmcQuotationList(widget.accId, widget.sessionId,widget.genid);
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Generatordetailsprovider>(
      builder: (context, provider, child) {
        final isLoading = provider.isLoading;
        final error = provider.errorMessage;
        final response = provider.amcQuotationResponse;

        final data = response?.amcQuotations??[];

        if (isLoading) {
          return const Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(
              child: CircularProgressIndicator(color: AppColors.buttonColor),
            ),
          );
        }

        if (error != null) {
          return Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(
              child: Text(
                error,
                style: const TextStyle(color: Colors.red, fontSize: 16),
              ),
            ),
          );
        }

        if (data == null) {
          return const Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(child: Text("No data found.")),
          );
        }
        return RefreshIndicator.adaptive(
          color: AppColors.amountText,
          onRefresh: () async {
            await Future.delayed(const Duration(milliseconds: 600));
          },

          child: Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: CustomScrollView(
              physics: const BouncingScrollPhysics(),
              slivers: [
                SliverAppBar(
                  stretch: true,
                  pinned: true,
                  expandedHeight: 75,
                  backgroundColor: AppColors.backgroundRegular,
                  elevation: 0,
                  // Remove shadow
                  automaticallyImplyLeading: false,
                  toolbarHeight: 0,
                  // Remove toolbar space
                  collapsedHeight: 0,
                  // Completely collapse to 0 height
                  flexibleSpace: FlexibleSpaceBar(
                    stretchModes: const [StretchMode.fadeTitle],
                    background: Container(
                      decoration: BoxDecoration(
                        gradient: AppColors.balanceBarGradientA,
                      ),
                      child: SafeArea(
                        child: Padding(
                          padding: const EdgeInsets.symmetric(
                            horizontal: 16,
                            vertical: 20,
                          ),
                          child: SizedBox(
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                InkResponse(
                                  onTap: () {
                                    HapticFeedback.selectionClick();

                                    Navigator.pop(context, true);
                                  },
                                  child: SvgPicture.asset(
                                    "assets/svg/appbar_back.svg",
                                    height: 25,
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  flex: 4,
                                  child: InkResponse(
                                    onTap: () {
                                      HapticFeedback.selectionClick();

                                      Navigator.pop(context, true);
                                    },
                                    child: Text(
                                      "AMC Quotation List",
                                      overflow: TextOverflow.ellipsis,
                                      maxLines: 1,
                                      style: TextStyle(
                                        fontSize: 16,
                                        color: Colors.white,
                                        height: 1.1,
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                    ),
                  ),
                ),

                SliverToBoxAdapter(
                  child: Container(
                    color: Color(0xFF4076FF),
                    child: Container(
                      decoration: const BoxDecoration(
                        color: AppColors.backgroundRegular,
                        borderRadius: BorderRadius.only(
                          topLeft: Radius.circular(30),
                          topRight: Radius.circular(30),
                        ),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          SizedBox(height: 4),

                          ListView.builder(
                            shrinkWrap: true,
                            physics: const NeverScrollableScrollPhysics(),
                            itemCount: data!.length,
                            itemBuilder: (context, j) {
                              return Container(
                                margin: const EdgeInsets.symmetric(vertical: 5, horizontal: 10),
                                decoration: BoxDecoration(
                                  color: data[j].amcStatus == "1" ? Color(0xFFD7F0FF) : Color(0xFFE0E0E0),
                                  borderRadius: BorderRadius.circular(14),
                                ),
                                child: Column(
                                  children: [
                                    Container(
                                      padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 10),

                                      decoration: BoxDecoration(
                                        color: Colors.white,
                                        borderRadius: BorderRadius.circular(14),
                                        border: Border.all(
                                          color:
                                          data[j].amcStatus == "1"
                                              ? AppColors.buttonColor
                                              : Colors.white,
                                        ),
                                      ),
                                      child: Column(
                                        children: [
                                          Row(
                                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                            children: [
                                              Row(
                                                mainAxisSize: MainAxisSize.min,
                                                children: [
                                                  SvgPicture.asset(
                                                    "assets/svg/tick_ic.svg",
                                                    height: 14,
                                                    color:
                                                    data[j].amcStatus == "1"
                                                        ? AppColors.greenICBg
                                                        : AppColors.subtitleText,
                                                  ),
                                                  const SizedBox(width: 4),
                                                  Text(
                                                    "AMC ",
                                                    style: TextStyle(
                                                      fontSize: 15,
                                                      fontFamily: "PoppinsBold",
                                                      fontStyle: FontStyle.italic,
                                                      fontWeight: FontWeight.w700,
                                                      color:
                                                      data[j].amcStatus == "1"
                                                          ? AppColors.greenICBg
                                                          : AppColors.subtitleText,
                                                    ),
                                                  ),
                                                  Text(
                                                    "Protected",
                                                    style: TextStyle(
                                                      fontSize: 15,
                                                      fontFamily: "PoppinsBold",
                                                      fontStyle: FontStyle.italic,
                                                      fontWeight: FontWeight.w700,
                                                      color:
                                                      data[j].amcStatus == "1"
                                                          ? AppColors.normalText
                                                          : AppColors.subtitleText,
                                                    ),
                                                  ),
                                                  const SizedBox(width: 4),
                                                  if (data[j].amcStatus == "2")
                                                    const Icon(
                                                      Icons.info_outline,
                                                      color: Colors.red,
                                                      size: 12,
                                                    ),
                                                ],
                                              ),
                                              Container(
                                                padding: EdgeInsets.symmetric(vertical: 3, horizontal: 5),
                                                decoration: BoxDecoration(
                                                  borderRadius: BorderRadius.circular(8),
                                                  color:
                                                  data[j].amcStatus == "1"
                                                      ? AppColors.successBG
                                                      : Color(0xFFFFF8D2),
                                                ),
                                                child: Center(
                                                  child: Text(
                                                    data[j].expNote ?? "-",
                                                    style: TextStyle(
                                                      fontSize: 14,
                                                      color:
                                                      data[j].amcStatus == "1"
                                                          ? AppColors.success
                                                          : AppColors.error,
                                                    ),
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                          Divider(color: Color(0xFF777777), thickness: 0.3),
                                          Row(
                                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                            children: [
                                              Column(
                                                crossAxisAlignment: CrossAxisAlignment.start,
                                                children: [
                                                  Text(
                                                    "Purchased On",
                                                    style: TextStyle(
                                                      color: AppColors.subtitleText,
                                                      fontSize: 12,
                                                    ),
                                                  ),
                                                  Text(data[j].purchaseDate!),
                                                ],
                                              ),
                                              Text(
                                                "₹${data[j].price}" ?? "-",
                                                style: TextStyle(
                                                  color:
                                                  data[j].amcStatus == "1"
                                                      ? AppColors.buttonColor
                                                      : AppColors.nearDarkText,
                                                  fontSize: 14,
                                                ),
                                              ),
                                            ],
                                          ),
                                        ],
                                      ),
                                    ),
                                    Container(
                                      padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                                      child: Row(
                                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                        children: [
                                          rowText(data[j].noOfVisits, "No. of Visits"),
                                          rowText(data[j].noOfOilServices, "No. of Oil Services"),
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            },
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }

  Widget rowText(text1, text2) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Container(
          height: 20,
          width: 20,
          decoration: BoxDecoration(
            color: Colors.white,
            shape: BoxShape.circle,
          ),
          child: Center(
            child: Text(
              text1,
              style: TextStyle(color: AppColors.nearDarkText, fontSize: 12),
            ),
          ),
        ),
        SizedBox(width: 5),
        Text(
          text2,
          style: TextStyle(color: AppColors.nearDarkText, fontSize: 12),
        ),
      ],
    );
  }
}
