import 'dart:convert';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:gen_service/Models/HelpAndComplaintModels/allJobCardListResponse.dart';
import 'package:gen_service/Models/HelpAndComplaintModels/allServiceListResponse.dart';
import 'package:gen_service/Services/api_calling.dart';


class ServiceAndJobCardListProvider extends ChangeNotifier {
  bool _isLoading = false;
  String? _errorMessage;
  allJobCardListResponse? _allJobCardResponse;

  allServiceListResponse? _allServiceResponse;

  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;

  allJobCardListResponse? get allJobCardResponse => _allJobCardResponse;
  allServiceListResponse? get allServiceResponse => _allServiceResponse;

  Map<String, int> _localRatings = {};
  Map<String, List<bool>> _starStates = {};

  int getRating(String serviceId) => _localRatings[serviceId] ?? 0;

  List<bool> getStarStates(String serviceId) {
    return _starStates.putIfAbsent(serviceId, () => List.filled(5, false));
  }

  void setRating(String serviceId, int rating, {bool notify = true}) {
    _localRatings[serviceId] = rating;
    final stars = getStarStates(serviceId);
    for (int i = 0; i < 5; i++) {
      stars[i] = i < rating;
    }
    if (notify) notifyListeners();
  }

  void initRatingsFromData(List<AllServiceList> services) {
    for (var service in services) {
      final id = service.id?.toString() ?? service.id.toString();
      final backendRating = int.parse(service.customerServiceRating.toString()) ?? 0;
      setRating(id, backendRating, notify: false);
    }
    notifyListeners();
  }

  Future<void> fetchAllJobCardsListAPI(String accId, String sessionId,complaintId) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();
    try {
      final response = await ApiCalling.jobCardsListAPI(accId, sessionId,complaintId);

      if (response != null) {
        if (response.error == "0") {
          _allJobCardResponse = response;
        } else {
          _errorMessage = response.message ?? "Something went wrong!";
        }
      } else {
        _errorMessage = "No response from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch dashboard: $e";
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }
  Future<void> fetchServiceDetailsAPI(String accId, String sessionId,complaintId) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();
    try {
      final response = await ApiCalling.serviceListAPI(accId, sessionId,complaintId);

      if (response != null) {
        if (response.error == "0") {
          _allServiceResponse = response;
          initRatingsFromData(response.allServiceList??[]);
        } else {
          _errorMessage = response.message ?? "Something went wrong!";
        }
      } else {
        _errorMessage = "No response from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch dashboard: $e";
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }


  Future<void> updateRatingForTechnician(String accId, String sessionId,complaintId,rating) async {

    // _errorMessage = null;
    notifyListeners();
    try {
      final response = await ApiCalling.updateTechRatingAPI(accId, sessionId,complaintId,rating);

      if (response != null) {
        if (response.error == "0") {
          fetchServiceDetailsAPI(accId, sessionId,complaintId);

            setRating(complaintId, rating);


        } else {
          // _errorMessage = response.message ?? "Something went wrong!";
        }
      } else {
        // _errorMessage = "No response from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch dashboard: $e";
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  void _setLoading(bool value) {
    _isLoading = value;
    notifyListeners();
  }

  void clearData() {
    _allJobCardResponse = null;
    _allServiceResponse = null;
    _errorMessage = null;
    notifyListeners();
  }
}
