class complaintListResponse {
  String? error;
  List<ComplaintList>? complaintList;
  String? message;

  complaintListResponse({this.error, this.complaintList, this.message});

  complaintListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['complaint_list'] != null) {
      complaintList = <ComplaintList>[];
      json['complaint_list'].forEach((v) {
        complaintList!.add(new ComplaintList.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.complaintList != null) {
      data['complaint_list'] =
          this.complaintList!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    return data;
  }
}

class ComplaintList {
  String? id;
  String? openStatus;
  String? modelName;
  String? registredDate;
  String? hashId;
  String? productName;
  String? complaintName;

  ComplaintList(
      {this.id,
        this.openStatus,
        this.modelName,
        this.registredDate,
        this.hashId,
        this.productName,
        this.complaintName});

  ComplaintList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    openStatus = json['open_status'];
    modelName = json['model_name'];
    registredDate = json['registred_date'];
    hashId = json['hash_id'];
    productName = json['product_name'];
    complaintName = json['complaint_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['open_status'] = this.openStatus;
    data['model_name'] = this.modelName;
    data['registred_date'] = this.registredDate;
    data['hash_id'] = this.hashId;
    data['product_name'] = this.productName;
    data['complaint_name'] = this.complaintName;
    return data;
  }
}
