class amcQuotationListResponse {
  String? error;
  List<AmcQuotations>? amcQuotations;
  String? message;

  amcQuotationListResponse({this.error, this.amcQuotations, this.message});

  amcQuotationListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['amc_quotations'] != null) {
      amcQuotations = <AmcQuotations>[];
      json['amc_quotations'].forEach((v) {
        amcQuotations!.add(new AmcQuotations.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.amcQuotations != null) {
      data['amc_quotations'] =
          this.amcQuotations!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    return data;
  }
}

class AmcQuotations {
  String? id;
  String? noOfVisits;
  String? price;
  String? amcStatus;
  String? expNote;
  String? noOfOilServices;
  String? purchaseDate;

  AmcQuotations(
      {this.id,
        this.noOfVisits,
        this.price,
        this.amcStatus,
        this.expNote,
        this.noOfOilServices,
        this.purchaseDate});

  AmcQuotations.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    noOfVisits = json['no_of_visits'];
    price = json['price'];
    amcStatus = json['amc_status'];
    expNote = json['exp_note'];
    noOfOilServices = json['no_of_oil_services'];
    purchaseDate = json['purchase_Date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['no_of_visits'] = this.noOfVisits;
    data['price'] = this.price;
    data['amc_status'] = this.amcStatus;
    data['exp_note'] = this.expNote;
    data['no_of_oil_services'] = this.noOfOilServices;
    data['purchase_Date'] = this.purchaseDate;
    return data;
  }
}
