class allServiceListResponse {
  String? error;
  List<TechDetails>? techDetails;
  List<AllServiceList>? allServiceList;
  String? message;

  allServiceListResponse(
      {this.error, this.techDetails, this.allServiceList, this.message});

  allServiceListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['tech_details'] != null) {
      techDetails = <TechDetails>[];
      json['tech_details'].forEach((v) {
        techDetails!.add(new TechDetails.fromJson(v));
      });
    }
    if (json['all_service_list'] != null) {
      allServiceList = <AllServiceList>[];
      json['all_service_list'].forEach((v) {
        allServiceList!.add(new AllServiceList.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.techDetails != null) {
      data['tech_details'] = this.techDetails!.map((v) => v.toJson()).toList();
    }
    if (this.allServiceList != null) {
      data['all_service_list'] =
          this.allServiceList!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    return data;
  }
}

class TechDetails {
  String? id;
  String? empName;
  String? techRoleName;
  String? mobNum;
  String? lat;
  String? lng;
  String? profileImg;

  TechDetails(
      {this.id,
        this.empName,
        this.techRoleName,
        this.mobNum,
        this.lat,
        this.lng,
        this.profileImg});

  TechDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    empName = json['emp_name'];
    techRoleName = json['tech_role_name'];
    mobNum = json['mob_num'];
    lat = json['lat'];
    lng = json['lng'];
    profileImg = json['profile_img'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['emp_name'] = this.empName;
    data['tech_role_name'] = this.techRoleName;
    data['mob_num'] = this.mobNum;
    data['lat'] = this.lat;
    data['lng'] = this.lng;
    data['profile_img'] = this.profileImg;
    return data;
  }
}

class AllServiceList {
  String? id;
  String? lat;
  String? lng;
  String? empName;
  String? date;
  String? techRoleName;
  String? mobNum;
  String? profileImg;
  String? feedback;
  String? openStatus;
  String? customerServiceRating;
  String? inOrOutTime;
  String? runningHrs;
  String? filePath;
  String? fsrExt;
  String? fsrNo;

  AllServiceList(
      {this.id,
        this.lat,
        this.lng,
        this.empName,
        this.date,
        this.techRoleName,
        this.mobNum,
        this.profileImg,
        this.feedback,
        this.openStatus,
        this.customerServiceRating,
        this.inOrOutTime,
        this.runningHrs,
        this.filePath,
        this.fsrExt,
        this.fsrNo});

  AllServiceList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    lat = json['lat'];
    lng = json['lng'];
    empName = json['emp_name'];
    date = json['date'];
    techRoleName = json['tech_role_name'];
    mobNum = json['mob_num'];
    profileImg = json['profile_img'];
    feedback = json['feedback'];
    openStatus = json['open_status'];
    customerServiceRating = json['customer_service_rating'];
    inOrOutTime = json['in_or_out_time'];
    runningHrs = json['running_hrs'];
    filePath = json['file_path'];
    fsrExt = json['fsr_ext'];
    fsrNo = json['fsr_no'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['lat'] = this.lat;
    data['lng'] = this.lng;
    data['emp_name'] = this.empName;
    data['date'] = this.date;
    data['tech_role_name'] = this.techRoleName;
    data['mob_num'] = this.mobNum;
    data['profile_img'] = this.profileImg;
    data['feedback'] = this.feedback;
    data['open_status'] = this.openStatus;
    data['customer_service_rating'] = this.customerServiceRating;
    data['in_or_out_time'] = this.inOrOutTime;
    data['running_hrs'] = this.runningHrs;
    data['file_path'] = this.filePath;
    data['fsr_ext'] = this.fsrExt;
    data['fsr_no'] = this.fsrNo;
    return data;
  }
}
