class GeneratorListResponse {
  String? error;
  List<Orders>? orders;
  String? message;

  GeneratorListResponse({this.error, this.orders, this.message});

  GeneratorListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['orders'] != null) {
      orders = <Orders>[];
      json['orders'].forEach((v) {
        orders!.add(new Orders.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.orders != null) {
      data['orders'] = this.orders!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    return data;
  }
}

class Orders {
  String? id;
  String? hashId;
  String? engine;
  String? prodName;
  String? amc;
  String? warranty;
  String? productImage;
  List<String>? schedule;

  Orders(
      {this.id,
        this.hashId,
        this.engine,
        this.prodName,
        this.amc,
        this.warranty,
        this.productImage,
        this.schedule});

  Orders.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    hashId = json['hash_id'];
    engine = json['engine'];
    prodName = json['prod_name'];
    amc = json['amc'];
    warranty = json['warranty'];
    productImage = json['productImage'];
    schedule = json['schedule'].cast<String>();
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['hash_id'] = this.hashId;
    data['engine'] = this.engine;
    data['prod_name'] = this.prodName;
    data['amc'] = this.amc;
    data['warranty'] = this.warranty;
    data['productImage'] = this.productImage;
    data['schedule'] = this.schedule;
    return data;
  }
}
