import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:gen_service/Notifiers/generatorDetailsProvider.dart';
import 'package:gen_service/Screens/HelpAndComplaintScreens/ComplaintListScreen.dart';
import 'package:gen_service/Screens/HelpAndComplaintScreens/SelectOrderHelpScreen.dart';
import 'package:gen_service/Screens/amcQuotationListScreen.dart';
import 'package:gen_service/Screens/complaintListScreen.dart';
import 'package:gen_service/Screens/quotationListScreen.dart';
import 'package:gen_service/Screens/scheduleListScreen.dart';
import 'package:provider/provider.dart';

import '../Models/generatorDetailsResponse.dart';
import '../Utility/AppColors.dart';



class Generatordetailsscreen extends StatefulWidget {
  final accId;
  final sessionId;
  final genId;

  const Generatordetailsscreen({
    super.key,
    required this.accId,
    required this.sessionId,
    required this.genId,
  });

  @override
  State<Generatordetailsscreen> createState() => _GeneratordetailsscreenState();
}

class _GeneratordetailsscreenState extends State<Generatordetailsscreen> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final detailsProvider = Provider.of<Generatordetailsprovider>(
        context,
        listen: false,
      );
      detailsProvider.fetchGeneratorDetails(
        widget.accId,
        widget.sessionId,
        widget.genId,
      );
    });
  }

  @override
  Widget build(BuildContext context) {
    double screenHeight = MediaQuery.of(context).size.height;
    return Consumer<Generatordetailsprovider>(
      builder: (context, detailsProvider, child) {
        final isLoading = detailsProvider.isLoading;
        final error = detailsProvider.errorMessage;
        final data = detailsProvider.detailsResponse;
        final genDetails = data?.genDetails??GenDetails();
        final locDetails = data?.locationDetails??LocationDetails();
        final quotationsList = data?.quotations??[];
        final scheduleList = data?.schedule ?? [];
        final amcQuotationsList = data?.amcQuotations??[];
        final complaintList = data?.complaints??[];

        List<String> sectionTitles = ["Generator Details", "Location Details"];
        List<String> headings1 = [
          "Date of Engine Purchase",
          "Alternator No.",
          "Engine Model",
          "Battery No.",
          "Commissioning Date",
          "Dispatch Date",
        ];
        List<String> subHeadings1 = [
          genDetails?.purchaseDate ?? "-",
          genDetails?.altNo ?? "-",
          genDetails?.modelName ?? "-",
          genDetails?.batterNo ?? "-",
          genDetails?.commisDate ?? "-",
          genDetails?.dispDate ?? "-",
        ];

        List<String> headings2 = ["District", "State", "Address"];
        List<String> subHeadings2 = [
          locDetails?.districtName ?? "-",
          locDetails?.stateName ?? "-",
          locDetails?.address ?? "-",
        ];
        List<List<String>>  headings = [headings1, headings2];
        List<List<String>> subHeadings = [subHeadings1, subHeadings2];

        if (isLoading) {
          return const Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(
              child: CircularProgressIndicator(color: AppColors.buttonColor),
            ),
          );
        }

        if (error != null) {
          return Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(
              child: Padding(
                padding: const EdgeInsets.all(24.0),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    // Error Icon
                    Container(
                      width: 120,
                      height: 120,
                      decoration: BoxDecoration(
                        color: Colors.red.withOpacity(0.1),
                        shape: BoxShape.circle,
                      ),
                      child: const Icon(
                        Icons.error_outline_rounded,
                        size: 60,
                        color: Colors.red,
                      ),
                    ),

                    const SizedBox(height: 24),

                    // Error Title
                    const Text(
                      "Oops! Something went wrong",
                      style: TextStyle(
                        fontSize: 20,
                        fontWeight: FontWeight.w600,
                        color: Colors.black87,
                        fontFamily: "Poppins",
                      ),
                    ),

                    const SizedBox(height: 12),

                    // Error Message
                    Text(
                      error,
                      textAlign: TextAlign.center,
                      style: const TextStyle(
                        fontSize: 14,
                        color: Colors.grey,
                        fontFamily: "Poppins",
                        height: 1.4,
                      ),
                    ),

                    const SizedBox(height: 32),

                    // Retry Button
                    ElevatedButton.icon(
                      onPressed: () async {
                        // Show loading state
                        setState(() {});

                        await Future.delayed(const Duration(milliseconds: 300));

                        // Retry fetching data
                        final detailsProvider = Provider.of<Generatordetailsprovider>(
                          context,
                          listen: false,
                        );
                        detailsProvider.fetchGeneratorDetails(
                          widget.accId,
                          widget.sessionId,
                          widget.genId,
                        );
                      },
                      style: ElevatedButton.styleFrom(
                        backgroundColor: AppColors.buttonColor,
                        foregroundColor: Colors.white,
                        padding: const EdgeInsets.symmetric(
                          horizontal: 24,
                          vertical: 12,
                        ),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.circular(25),
                        ),
                        elevation: 2,
                      ),
                      icon: const Icon(Icons.refresh_rounded, size: 20),
                      label: const Text(
                        "Try Again",
                        style: TextStyle(
                          fontSize: 16,
                          fontWeight: FontWeight.w500,
                          fontFamily: "Poppins",
                        ),
                      ),
                    ),

                    const SizedBox(height: 16),

                    // Alternative Action
                    TextButton(
                      onPressed: () {
                        // Go back or navigate to home
                        Navigator.pop(context);
                      },
                      child: const Text(
                        "Go Back",
                        style: TextStyle(
                          fontSize: 14,
                          color: Colors.grey,
                          fontFamily: "Poppins",
                        ),
                      ),
                    ),
                  ],
                ),
              ),
            ),
          );
        }

        if (data == null) {
          return const Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(child: Text("No data found.")),
          );
        }
        return SafeArea(
          maintainBottomViewPadding: true,
          top: false,
          bottom: Platform.isIOS ? false : true,
          child: Scaffold(
            backgroundColor: Color(0xFF4076FF),


            body: CustomScrollView(
              slivers: [

                SliverAppBar(
                  automaticallyImplyLeading: false,
                  stretch: true,
                  onStretchTrigger: () async {
                  },
                  stretchTriggerOffset: 300.0,
                  backgroundColor: Color(0xFF4076FF),
                  expandedHeight: detailsProvider.showMoreDetails?screenHeight*0.62:screenHeight*0.26,
                  flexibleSpace: FlexibleSpaceBar(
                    stretchModes: const [
                      StretchMode.zoomBackground,
                      StretchMode.blurBackground,
                    ],
                    background: Container(
                      decoration: const BoxDecoration(gradient: AppColors.commonAppBarGradient),
                      child: SafeArea(
                        child: Column(
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                SizedBox(width: 8,),
                                InkResponse(
                                  onTap: () {
                                    HapticFeedback.selectionClick();
                                    Navigator.pop(context, true);
                                  },
                                  child: SvgPicture.asset(
                                    "assets/svg/appbar_back.svg",
                                    height: 25,
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  flex: 4,
                                  child: InkResponse(
                                    onTap: () {
                                      HapticFeedback.selectionClick();

                                      Navigator.pop(context, true);
                                    },
                                    child: Text(
                                      "Generator Details",
                                      overflow: TextOverflow.ellipsis,
                                      maxLines: 1,
                                      style: TextStyle(
                                        fontSize: 16,
                                        color: Colors.white,
                                        height: 1.1,
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),

                            SizedBox(height: 10,),
                            Container(
                              padding: const EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 12,
                              ),
                              child: Column(
                                children: [
                                  // Product Info Row
                                  Padding(
                                    padding: const EdgeInsets.symmetric(vertical: 4.0),
                                    child: Row(
                                      children: [
                                        Expanded(
                                          flex: 5,
                                          child: Column(
                                            crossAxisAlignment: CrossAxisAlignment.start,
                                            children: [
                                              RichText(
                                                text: TextSpan(
                                                  style: const TextStyle(
                                                    fontFamily: 'Poppins',
                                                    height: 2.5,
                                                    color: Color(0xFF48F3FF),
                                                    fontSize: 13,
                                                  ),
                                                  children: [
                                                    TextSpan(text: "#${data.hashId!}"),
                                                    TextSpan(
                                                      text: " | Engine: ${data.engine!}",
                                                    ),
                                                  ],
                                                ),
                                              ),
                                              Padding(
                                                padding: const EdgeInsets.symmetric(vertical: 3.0),
                                                child: Text(
                                                  data.prodName!,
                                                  maxLines: 2,
                                                  style: const TextStyle(
                                                    height: 1.5,
                                                    color: Colors.white,
                                                    fontSize: 14,
                                                  ),
                                                ),
                                              ),
                                              if (data.amc != "0") ...[
                                                SizedBox(height: 5,),
                                                Container(
                                                  padding: const EdgeInsets.symmetric(
                                                    horizontal: 8,
                                                    vertical: 4,
                                                  ),
                                                  decoration: BoxDecoration(
                                                    gradient:
                                                    data.amc == "1"
                                                        ? AppColors.greenStripGradient
                                                        : AppColors.fadeGradient,
                                                    borderRadius: BorderRadius.circular(12),
                                                  ),
                                                  child: Row(
                                                    mainAxisSize: MainAxisSize.min,
                                                    children: [
                                                      SvgPicture.asset(
                                                        "assets/svg/tick_ic.svg",
                                                        height: 15,
                                                        color:
                                                        data.amc == "1"
                                                            ? Color(0xFF00BC56)
                                                            : AppColors.subtitleText,
                                                      ),
                                                      const SizedBox(width: 4),
                                                      Text(
                                                        "AMC ",
                                                        style: TextStyle(
                                                          fontSize: 12,
                                                          fontFamily: "HemiHead",
                                                          fontStyle: FontStyle.italic,
                                                          color:
                                                          data.amc == "1"
                                                              ? Color(0xFF00BC56)
                                                              : AppColors.subtitleText,
                                                        ),
                                                      ),
                                                      Text(
                                                        "PROTECTED",
                                                        style: TextStyle(
                                                          fontSize: 12,
                                                          fontFamily: "HemiHead",
                                                          fontStyle: FontStyle.italic,
                                                          color:
                                                          data.amc == "1"
                                                              ? AppColors.normalText
                                                              : AppColors.subtitleText,
                                                        ),
                                                      ),
                                                      const SizedBox(width: 4),
                                                      if (data.amc == "2")
                                                        const Icon(
                                                          Icons.error_outline,
                                                          color: Colors.red,
                                                          size: 15,
                                                        ),
                                                    ],
                                                  ),
                                                ),
                                              ],
                                              if (data.warranty != "0") ...[
                                                SizedBox(height: 5,),
                                                Row(
                                                  mainAxisSize: MainAxisSize.min,
                                                  children: [
                                                    Container(
                                                      padding: const EdgeInsets.symmetric(
                                                        horizontal: 8,
                                                        vertical: 4,
                                                      ),
                                                      decoration: BoxDecoration(
                                                        gradient:
                                                        data.warranty == "1"
                                                            ? AppColors.yellowStripGradient
                                                            : AppColors.fadeGradient,
                                                        borderRadius: BorderRadius.circular(12),
                                                      ),
                                                      child: Row(
                                                        children: [
                                                          SvgPicture.asset(
                                                            data.warranty == "1"
                                                                ? "assets/svg/tick2_ic.svg":
                                                            "assets/svg/tick3_ic.svg",
                                                            height: 15,
                                                          ),
                                                          const SizedBox(width: 6),
                                                          Text(
                                                            "WARRANTY",
                                                            style: TextStyle(
                                                              fontSize: 12,
                                                              fontFamily: "HemiHead",
                                                              fontStyle: FontStyle.italic,
                                                              color:
                                                              data.warranty == "1"
                                                                  ? AppColors.normalText
                                                                  : AppColors
                                                                  .nearDarkText,
                                                            ),
                                                          ),
                                                          SizedBox(width: 6),
                                                          if (data.warranty == "2")
                                                            const Icon(
                                                              Icons.error_outline,
                                                              color: Colors.red,
                                                              size: 15,
                                                            ),
                                                        ],
                                                      ),
                                                    ),
                                                  ],
                                                ),
                                              ],
                                            ],
                                          ),
                                        ),
                                        Expanded(
                                          flex: 2,
                                          child: Image.network(
                                            data.prodImg!,
                                            fit: BoxFit.scaleDown,
                                          ),
                                        ),
                                      ],
                                    ),
                                  ),

                                  // Show More Details
                                  if (detailsProvider.showMoreDetails) ...[
                                    const Divider(color: Colors.white),
                                    ...List.generate(headings.length, (index) {
                                      final sectionTitle = sectionTitles[index];
                                      final sectionItems = headings[index];
                                      final sectionSubItems = subHeadings[index];
                                      return Padding(
                                        padding: const EdgeInsets.only(top: 12),
                                        child: Row(
                                          crossAxisAlignment: CrossAxisAlignment.start,
                                          children: [
                                            Container(
                                              height: 25,
                                              width: 25,
                                              decoration: const BoxDecoration(
                                                shape: BoxShape.circle,
                                                color: Colors.white,
                                              ),
                                              child: Center(
                                                child: Text(
                                                  index == 0 ? "🔧" : "📍",
                                                  style: const TextStyle(fontSize: 14),
                                                ),
                                              ),
                                            ),
                                            const SizedBox(width: 8),
                                            Expanded(
                                              child: Column(
                                                crossAxisAlignment:
                                                CrossAxisAlignment.start,
                                                children: [
                                                  Text(
                                                    sectionTitle,
                                                    style: const TextStyle(
                                                      fontWeight: FontWeight.bold,
                                                      color: Colors.white,
                                                      fontSize: 16,
                                                    ),
                                                  ),
                                                  const SizedBox(height: 8),
                                                  ...List.generate(sectionItems.length, (
                                                      i,
                                                      ) {
                                                    return Padding(
                                                      padding: const EdgeInsets.symmetric(
                                                        vertical: 3,
                                                      ),
                                                      child: Row(
                                                        crossAxisAlignment: CrossAxisAlignment.start,
                                                        children: [
                                                          Expanded(
                                                            child: Text(
                                                              sectionItems[i]??"-",
                                                              style: const TextStyle(
                                                                fontSize: 14,
                                                                color: Color(0xFF48F3FF),
                                                              ),
                                                            ),
                                                          ),
                                                          Expanded(
                                                            child: Text(
                                                              sectionSubItems[i]??"-",
                                                              maxLines: 3,
                                                              overflow: TextOverflow.ellipsis,
                                                              textAlign: TextAlign.end,
                                                              style: const TextStyle(
                                                                fontSize: 14,
                                                                color: Colors.white,
                                                              ),
                                                            ),
                                                          ),
                                                        ],
                                                      ),
                                                    );
                                                  }),
                                                ],
                                              ),
                                            ),
                                          ],
                                        ),
                                      );
                                    }),
                                  ],

                                  Center(
                                    child: InkResponse(
                                      onTap:
                                          () =>
                                      detailsProvider.showMoreDetails =
                                      !detailsProvider.showMoreDetails,
                                      child: Container(
                                        width: 125,
                                        margin: const EdgeInsets.only(top: 5),
                                        padding: const EdgeInsets.symmetric(vertical: 6),
                                        decoration: BoxDecoration(
                                          borderRadius: BorderRadius.circular(16),
                                          border: Border.all(
                                            color: Colors.white,
                                            width: 0.7,
                                          ),
                                        ),
                                        child: Row(
                                          mainAxisAlignment: MainAxisAlignment.center,
                                          children: [
                                            Text(
                                              detailsProvider.showMoreDetails
                                                  ? "Hide Details"
                                                  : "View Details",
                                              style: const TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: Colors.white,
                                              ),
                                            ),
                                            const SizedBox(width: 4),
                                            Transform.flip(
                                              flipY: detailsProvider.showMoreDetails,
                                              child: SvgPicture.asset(
                                                "assets/svg/arrow_dropdown.svg",
                                                height: 12,
                                                width: 12,
                                                colorFilter: const ColorFilter.mode(
                                                  Colors.white,
                                                  BlendMode.srcIn,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ),
                                  const SizedBox(height: 10),
                                ],
                              ),
                            ),
                          ],
                        ),
                      )
                    ),
                  ),
                ),


                SliverFillRemaining(
                  hasScrollBody: false,
                  child: Container(
                    decoration: const BoxDecoration(
                      color: AppColors.backgroundRegular,
                      borderRadius: BorderRadius.only(
                        topLeft: Radius.circular(30),
                        topRight: Radius.circular(30),
                      ),
                    ),
                    padding: const EdgeInsets.fromLTRB(5, 20, 5, 30),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        if (scheduleList.isNotEmpty) ...[
                          sectionHeading("Scheduled Services"),
                          ...List.generate(
                            scheduleList.length,
                            (i) => _buildListItem(scheduleList[i]),
                          ),
                        ],

                        if (quotationsList.isNotEmpty) ...[
                          sectionHeading("Quotations"),
                          ...List.generate(
                            quotationsList.length,
                            (i) => _buildListItem1(
                              quotationsList[i]!.title ?? "-",
                              quotationsList[i]!.date ?? "-",
                            ),
                          ),
                        ],
                        if (complaintList.isNotEmpty) ...[
                          sectionHeading("Complaint Details"),
                          ...List.generate(
                            1,
                            (i) => _buildListItem2(complaintList[i]),
                          ),
                        ],
                        SizedBox(height: 10),
                        InkResponse(
                          onTap: () {
                            Navigator.push(
                                context,
                                MaterialPageRoute(builder: (context) => SelectOrderHelpScreen(accId: widget.accId, sessionId: widget.sessionId))
                            );
                          },
                          child: Padding(
                            padding: const EdgeInsets.symmetric(horizontal: 14),
                            child: Container(
                              padding: const EdgeInsets.all(20),
                              decoration: BoxDecoration(
                                color: const Color(0xFFD7F0FF),
                                borderRadius: BorderRadius.circular(16),
                                border: Border.all(
                                  width: 1.5,
                                  color: AppColors.buttonColor,
                                ),
                              ),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                children: [
                                  Column(
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: const [
                                      Text(
                                        'Facing Issues?',
                                        style: TextStyle(
                                          fontSize: 14,
                                          fontWeight: FontWeight.w500,
                                          color: AppColors.amountText,
                                        ),
                                      ),
                                      Text(
                                        'Raise a ticket to resolve your issues.',
                                        style: TextStyle(
                                          fontSize: 12,
                                          fontWeight: FontWeight.w400,
                                          color: AppColors.subtitleText,
                                        ),
                                      ),
                                    ],
                                  ),
                                  SvgPicture.asset(
                                    "assets/svg/requirements.svg",
                                    height: 32,
                                    width: 32,
                                  ),
                                ],
                              ),
                            ),
                          ),
                        ),
                        if (amcQuotationsList.isNotEmpty) ...[
                          sectionHeading("AMC Quotation Details"),
                          ...List.generate(
                            amcQuotationsList.length,
                            (i) => _buildListItem3(amcQuotationsList[i]!),
                          ),
                        ],
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }

  Widget sectionHeading(text) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            text,
            style: TextStyle(color: AppColors.nearDarkText, fontSize: 14),
          ),
          InkResponse(
            onTap: () async {
              var redirectScreen;
              switch (text) {
                case "Scheduled Services":
                  redirectScreen = ScheduleListScreen(
                    accId: widget.accId,
                    sessionId: widget.sessionId,
                    genId: widget.genId,
                  );
                  break;
                case "Quotations":
                  redirectScreen = QuotationListScreen(
                    accId: widget.accId,
                    sessionId: widget.sessionId,
                    genId: widget.genId,
                  );
                  break;
                case "Complaint Details":
                  redirectScreen = ComplaintListScreen(
                    accId: widget.accId,
                    sessionId: widget.sessionId,
                  );
                  break;
                case "AMC Quotation Details":
                  redirectScreen = AmcQuotationListScreen(
                    accId: widget.accId,
                    sessionId: widget.sessionId,
                    genid: widget.genId,
                  );
                  break;
                default:
                  break;
              }
              await Navigator.push(
                context,
                MaterialPageRoute(builder: (context) => redirectScreen),
              );
            },
            child: Padding(
              padding: const EdgeInsets.symmetric(horizontal: 8.0),
              child: Text(
                "See All",
                style: TextStyle(color: AppColors.buttonColor, fontSize: 14),
              ),
            ),
          ),
        ],
      ),
    );
  }

  Widget _buildListItem(Schedule data) {
    return Container(
      margin: const EdgeInsets.symmetric(vertical: 5, horizontal: 10),
      decoration: BoxDecoration(
        color:
            data.status == "Scheduled" ? Color(0xFFD7F0FF) : Color(0xFFE0E0E0),
        borderRadius: BorderRadius.circular(14),
      ),
      child: Column(
        children: [
          Container(
            padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 10),

            decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.circular(14),
              border: Border.all(
                color:
                    data.status == "Scheduled"
                        ? AppColors.buttonColor
                        : Colors.white,
              ),
            ),
            child: Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                    if (data.status == "Scheduled") ...[
                      SvgPicture.asset("assets/svg/calendar_ic.svg"),
                      SizedBox(width: 8),
                    ],
                    SizedBox(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          if (data.status == "Completed") ...[
                            Text(
                              data.complaintType ?? "-",
                              style: TextStyle(
                                fontSize: 14,
                                color: AppColors.nearDarkText,
                              ),
                            ),
                          ],
                          Text(
                            data.date ?? "-",
                            style: TextStyle(
                              fontSize: data.status == "Scheduled" ? 14 : 12,
                              color:
                                  data.status == "Scheduled"
                                      ? AppColors.nearDarkText
                                      : Color(0xFF777777),
                            ),
                          ),
                          ///AMC Warranty
                          if (data.amc != "0") ...[
                            SizedBox(height: 5,),
                            Container(
                              padding: const EdgeInsets.symmetric(
                                horizontal: 5,
                                vertical: 4,
                              ),
                              decoration: BoxDecoration(
                                gradient:
                                data.amc == "1"
                                    ? AppColors.greenStripGradient
                                    : AppColors.fadeGradient,
                                borderRadius: BorderRadius.circular(12),
                              ),
                              child: Row(
                                mainAxisSize: MainAxisSize.min,
                                children: [
                                  SvgPicture.asset(
                                    "assets/svg/tick_ic.svg",
                                    height: 15,
                                    color:
                                    data.amc == "1"
                                        ? AppColors.greenICBg
                                        : AppColors.subtitleText,
                                  ),
                                  const SizedBox(width: 4),
                                  Text(
                                    "AMC ",
                                    style: TextStyle(
                                      fontSize: 12,
                                      fontFamily: "PoppinsBold",
                                      fontStyle: FontStyle.italic,
                                      fontWeight: FontWeight.w700,
                                      color:
                                      data.amc == "1"
                                          ? AppColors.greenICBg
                                          : AppColors.subtitleText,
                                    ),
                                  ),
                                  Text(
                                    "Protected",
                                    style: TextStyle(
                                      fontSize: 12,
                                      fontFamily: "PoppinsBold",
                                      fontStyle: FontStyle.italic,
                                      fontWeight: FontWeight.w700,
                                      color:
                                      data.amc == "1"
                                          ? AppColors.normalText
                                          : AppColors.subtitleText,
                                    ),
                                  ),
                                  const SizedBox(width: 4),
                                  if (data.amc == "2")
                                    const Icon(
                                      Icons.error_outline,
                                      color: Colors.red,
                                      size: 15,
                                    ),
                                ],
                              ),
                            ),
                          ],
                          if (data.warranty != "0") ...[
                            SizedBox(height: 5,),
                            Container(
                              padding: const EdgeInsets.symmetric(
                                horizontal: 8,
                                vertical: 4,
                              ),
                              decoration: BoxDecoration(
                                gradient:
                                data.warranty == "1"
                                    ? AppColors.yellowStripGradient
                                    : AppColors.fadeGradient,
                                borderRadius: BorderRadius.circular(12),
                              ),
                              child: Row(
                                mainAxisSize: MainAxisSize.min,
                                children: [
                                  Row(
                                    children: [
                                      SvgPicture.asset(
                                        data.warranty == "1"
                                            ? "assets/svg/tick2_ic.svg":
                                        "assets/svg/tick3_ic.svg",
                                        height: 15,
                                      ),
                                      const SizedBox(width: 6),
                                      Text(
                                        "Warranty",
                                        style: TextStyle(
                                          fontSize: 12,
                                          fontFamily: "PoppinsBold",
                                          fontStyle: FontStyle.italic,
                                          fontWeight: FontWeight.w700,
                                          color:
                                          data.warranty == "1"
                                              ? AppColors.normalText
                                              : Color(0xFF969696),
                                        ),
                                      ),
                                      SizedBox(width: 6),
                                      if (data.warranty == "2")
                                        const Icon(

                                          Icons.error_outline,
                                          color: Colors.red,
                                          size: 15,
                                        ),
                                    ],
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ],
                      ),
                    ),
                    Spacer(),
                    Container(
                      padding: EdgeInsets.symmetric(vertical: 5, horizontal: 8),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8),
                        color:
                            data.status == "Scheduled"
                                ? AppColors.successBG
                                : Color(0xFFFFF8D2),
                      ),
                      child: Center(
                        child: Text(
                          data.status ?? "-",
                          style: TextStyle(
                            fontSize: 14,
                            color:
                                data.status == "Scheduled"
                                    ? AppColors.success
                                    : AppColors.nearDarkText,
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
          if (data.status == "Scheduled") ...[
            Container(
              padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  Text(
                    "Upcoming Service Scheduled",
                    style: TextStyle(
                      fontSize: 12,
                      color: AppColors.buttonColor,
                    ),
                  ),
                ],
              ),
            ),
          ],
        ],
      ),
    );
  }

  Widget _buildListItem1(String left, String right) {
    return Container(
      height: 50,
      padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 10),
      margin: const EdgeInsets.symmetric(vertical: 5, horizontal: 10),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(12),
      ),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [Text(left), Text(right)],
      ),
    );
  }

  Widget _buildListItem2(Complaints data) {
    return Container(
      padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 10),
      margin: const EdgeInsets.symmetric(vertical: 5, horizontal: 10),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(14),
      ),
      child: Column(
        children: [
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Expanded(
                flex: 7,
                child: SizedBox(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      RichText(
                        text: TextSpan(
                          style: const TextStyle(
                            fontFamily: 'Poppins',
                            color: Color(0xFF008CDE),
                            fontSize: 14,
                          ),
                          children: [
                            TextSpan(text: "#${data.id}"),
                            TextSpan(text: " | ${data.complaintName}"),
                          ],
                        ),
                      ),
                      Text(
                        "${data.registredDate}",
                        style: TextStyle(
                          color: AppColors.subtitleText,
                          fontSize: 12,
                        ),
                      ),
                    ],
                  ),
                ),
              ),

              Expanded(
                flex: 3,
                child: Container(
                  padding: EdgeInsets.symmetric(vertical: 6, horizontal: 10),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(8),
                    color: AppColors.successBG,
                  ),
                  child: Center(
                    child: Text(
                      "${data.openStatus}",
                      style: TextStyle(fontSize: 14, color: AppColors.success),
                    ),
                  ),
                ),
              ),
            ],
          ),
          Divider(color: Color(0xFF777777), thickness: 0.3),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Expanded(
                flex: 5,
                child: Text(
                  "${data.productName}",
                  overflow: TextOverflow.ellipsis,
                  maxLines: 2,
                  style: const TextStyle(
                    color: AppColors.nearDarkText,
                    fontSize: 12,
                  ),
                ),
              ),
              Expanded(
                flex: 5,
                child: RichText(
                  maxLines: 1,
                  textAlign: TextAlign.right,
                  text: TextSpan(
                    style: TextStyle(
                      fontFamily: 'Poppins',
                      color: AppColors.subtitleText,
                      fontSize: 12,
                    ),
                    children: [
                      TextSpan(text: "#${data.hashId}"),
                      TextSpan(text: " | Engine: ${data.modelName}"),
                    ],
                  ),
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }

  Widget _buildListItem3(AmcQuotations data) {
    return Container(
      margin: const EdgeInsets.symmetric(vertical: 5, horizontal: 10),
      decoration: BoxDecoration(
        color: data.amcStatus == "1" ? Color(0xFFD7F0FF) : Color(0xFFE0E0E0),
        borderRadius: BorderRadius.circular(14),
      ),
      child: Column(
        children: [
          Container(
            padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 10),

            decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.circular(14),
              border: Border.all(
                color:
                    data.amcStatus == "1"
                        ? AppColors.buttonColor
                        : Colors.white,
              ),
            ),
            child: Column(
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Row(
                      mainAxisSize: MainAxisSize.min,
                      children: [
                        SvgPicture.asset(
                          "assets/svg/tick_ic.svg",
                          height: 14,
                          color:
                              data.amcStatus == "1"
                                  ? AppColors.greenICBg
                                  : AppColors.subtitleText,
                        ),
                        const SizedBox(width: 4),
                        Text(
                          "AMC ",
                          style: TextStyle(
                            fontSize: 15,
                            fontFamily: "PoppinsBold",
                            fontStyle: FontStyle.italic,
                            fontWeight: FontWeight.w700,
                            color:
                                data.amcStatus == "1"
                                    ? AppColors.greenICBg
                                    : AppColors.subtitleText,
                          ),
                        ),
                        Text(
                          "Protected",
                          style: TextStyle(
                            fontSize: 15,
                            fontFamily: "PoppinsBold",
                            fontStyle: FontStyle.italic,
                            fontWeight: FontWeight.w700,
                            color:
                                data.amcStatus == "1"
                                    ? AppColors.normalText
                                    : AppColors.subtitleText,
                          ),
                        ),
                        const SizedBox(width: 4),
                        if (data.amcStatus == "2")
                          const Icon(
                            Icons.info_outline,
                            color: Colors.red,
                            size: 12,
                          ),
                      ],
                    ),
                    Container(
                      padding: EdgeInsets.symmetric(vertical: 3, horizontal: 5),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8),
                        color:
                            data.amcStatus == "1"
                                ? AppColors.successBG
                                : Color(0xFFFFF8D2),
                      ),
                      child: Center(
                        child: Text(
                          data.expNote ?? "-",
                          style: TextStyle(
                            fontSize: 14,
                            color:
                                data.amcStatus == "1"
                                    ? AppColors.success
                                    : AppColors.error,
                          ),
                        ),
                      ),
                    ),
                  ],
                ),
                Divider(color: Color(0xFF777777), thickness: 0.3),
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          "Purchased On",
                          style: TextStyle(
                            color: AppColors.subtitleText,
                            fontSize: 12,
                          ),
                        ),
                        Text(data.purchaseDate!),
                      ],
                    ),
                    Text(
                      "₹${data.price}" ?? "-",
                      style: TextStyle(
                        color:
                            data.amcStatus == "1"
                                ? AppColors.buttonColor
                                : AppColors.nearDarkText,
                        fontSize: 14,
                      ),
                    ),
                  ],
                ),
              ],
            ),
          ),
          Container(
            padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                rowText(data.noOfVisits, "No. of Visits"),
                rowText(data.noOfOilServices, "No. of Oil Services"),
              ],
            ),
          ),
        ],
      ),
    );
  }

  Widget rowText(text1, text2) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.spaceBetween,
      children: [
        Container(
          height: 20,
          width: 20,
          decoration: BoxDecoration(
            color: Colors.white,
            shape: BoxShape.circle,
          ),
          child: Center(
            child: Text(
              text1,
              style: TextStyle(color: AppColors.nearDarkText, fontSize: 12),
            ),
          ),
        ),
        SizedBox(width: 5),
        Text(
          text2,
          style: TextStyle(color: AppColors.nearDarkText, fontSize: 12),
        ),
      ],
    );
  }
}
