class DashboardResponse {
  String? error;
  String? mobNum;
  String? userName;
  String? userProfile;
  String? balanceAmount;
  String? balanceType;
  List<Orders>? orders;
  List<Complaints>? complaints;
  String? message;
  String? sessionExists;

  DashboardResponse(
      {this.error,
        this.mobNum,
        this.userName,
        this.userProfile,
        this.balanceAmount,
        this.balanceType,
        this.orders,
        this.complaints,
        this.message,
        this.sessionExists});

  DashboardResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    mobNum = json['mob_num'];
    userName = json['user_name'];
    userProfile = json['user_profile'];
    balanceAmount = json['balance_amount'];
    balanceType = json['balance_type'];
    if (json['orders'] != null) {
      orders = <Orders>[];
      json['orders'].forEach((v) {
        orders!.add(new Orders.fromJson(v));
      });
    }
    if (json['complaints'] != null) {
      complaints = <Complaints>[];
      json['complaints'].forEach((v) {
        complaints!.add(new Complaints.fromJson(v));
      });
    }
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['mob_num'] = this.mobNum;
    data['user_name'] = this.userName;
    data['user_profile'] = this.userProfile;
    data['balance_amount'] = this.balanceAmount;
    data['balance_type'] = this.balanceType;
    if (this.orders != null) {
      data['orders'] = this.orders!.map((v) => v.toJson()).toList();
    }
    if (this.complaints != null) {
      data['complaints'] = this.complaints!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class Orders {
  String? id;
  String? hashId;
  String? engine;
  String? prodName;
  String? amc;
  String? warranty;
  String? productImage;
  List<String>? schedule;

  Orders(
      {this.id,
        this.hashId,
        this.engine,
        this.prodName,
        this.amc,
        this.warranty,
        this.productImage,
        this.schedule});

  Orders.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    hashId = json['hash_id'];
    engine = json['engine'];
    prodName = json['prod_name'];
    amc = json['amc'];
    warranty = json['warranty'];
    productImage = json['productImage'];
    schedule = json['schedule'].cast<String>();
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['hash_id'] = this.hashId;
    data['engine'] = this.engine;
    data['prod_name'] = this.prodName;
    data['amc'] = this.amc;
    data['warranty'] = this.warranty;
    data['productImage'] = this.productImage;
    data['schedule'] = this.schedule;
    return data;
  }
}

class Complaints {
  String? id;
  String? openStatus;
  String? modelName;
  String? registredDate;
  String? hashId;
  String? productName;
  String? complaintName;

  Complaints(
      {this.id,
        this.openStatus,
        this.modelName,
        this.registredDate,
        this.hashId,
        this.productName,
        this.complaintName});

  Complaints.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    openStatus = json['open_status'];
    modelName = json['model_name'];
    registredDate = json['registred_date'];
    hashId = json['hash_id'];
    productName = json['product_name'];
    complaintName = json['complaint_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['open_status'] = this.openStatus;
    data['model_name'] = this.modelName;
    data['registred_date'] = this.registredDate;
    data['hash_id'] = this.hashId;
    data['product_name'] = this.productName;
    data['complaint_name'] = this.complaintName;
    return data;
  }
}
