class scheduleListResponse {
  String? error;
  List<AllScheduleServices>? allScheduleServices;
  String? message;

  scheduleListResponse({this.error, this.allScheduleServices, this.message});

  scheduleListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['all_schedule_services'] != null) {
      allScheduleServices = <AllScheduleServices>[];
      json['all_schedule_services'].forEach((v) {
        allScheduleServices!.add(new AllScheduleServices.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.allScheduleServices != null) {
      data['all_schedule_services'] =
          this.allScheduleServices!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    return data;
  }
}

class AllScheduleServices {
  String? id;
  String? dueDate;
  String? complaintType;
  String? comType;
  String? status;

  AllScheduleServices(
      {this.id, this.dueDate, this.complaintType, this.comType, this.status});

  AllScheduleServices.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    dueDate = json['due_date'];
    complaintType = json['complaint_type'];
    comType = json['com_type'];
    status = json['status'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['due_date'] = this.dueDate;
    data['complaint_type'] = this.complaintType;
    data['com_type'] = this.comType;
    data['status'] = this.status;
    return data;
  }
}
