// utils/app_colors.dart
import 'dart:ui';

import 'package:flutter/cupertino.dart';

class AppColors {
  // Primary colors from genrentals.in
  static const Color primary = Color(0xFF00BBDB);
  static const Color secondary = Color(0xFFF3F4F6);
  static const Color accent = Color(0xFFF59E0B);

  // Text colors
  static const Color headerText = Color(0xFF2D2D2D);
  static const Color amountText = Color(0xFF008CDE);
  static const Color normalText = Color(0xFF2D2D2D);
  static const Color subtitleText = Color(0xFF777777);
  static const Color warningText = Color(0xFFF00000);
  static const Color nearDarkText = Color(0xFF1E1E1E);
  static const Color skyBlueText = Color(0xFF48F3FF);

  // Status colors
  static const Color success = Color(0xFF007736);
  static const Color warning = Color(0xFFF59E0B);
  static const Color error = Color(0xFFEF4444);
  static const Color info = Color(0xFF3B82F6);


// Status background  colors
  static const Color successBG = Color(0xFFDCFCE7);
  static const Color greenICBg = Color(0xFF4CAF50);
  static const Color yellowBG = Color(0xFFFFF8D2);
  static const Color warningBg = Color(0xFFFF8940);
  static const Color warningBg2 = Color(0xFFFFE5E5);
  static const Color errorBg = Color(0xFFDB0000);
  static const Color stripSky = Color(0xFFD9F1FF);
  static const Color stripGrey = Color(0xFFE0E0E0);
  static const Color fieldsGrey = Color(0xFFF6F6F8);

  // Neutral colors
  static const Color dark = Color(0xFF1F2937);
  static const Color light = Color(0xFFF9FAFB);
  static const Color gray = Color(0xFF6B7280);

  // Background colors
  static const Color backgroundLight = Color(0xFFFFFFFF);
  static const Color backgroundDark = Color(0xFF111827);
  static const Color backgroundRegular = Color(0xFFF2F2F2);
  static const Color backgroundBottom = Color(0xFF4076FF);
  //Button
  static const Color buttonColor = Color(0xFF008CDE);

  /// Gradients
  static const LinearGradient backgroundGradient = LinearGradient(
    begin: Alignment.topCenter,
    end: Alignment.bottomCenter,
    colors: [
      Color(0xFF00BBDB),
      Color(0xFF4076FF),
    ],
  );

  static const LinearGradient successGradient = LinearGradient(
    begin: Alignment.topCenter,
    end: Alignment.bottomCenter,
    colors: [
      Color(0xFFE4F2FF),
      Color(0xFFDCFCE7),
    ],
  );
  static const LinearGradient fadeGradient = LinearGradient(
    begin: Alignment.topLeft,
    end: Alignment.bottomRight,
    colors: [
      Color(0xFFD7D7D7),
      Color(0x00FFFFFF),
    ],
  );

  static const LinearGradient yellowGradient = LinearGradient(
    begin: Alignment.topCenter,
    end: Alignment.bottomCenter,
    colors: [
      Color(0xFFE4F2FF),
      Color(0xFFFFF8D2),
    ],
  );

  static  LinearGradient yellowStripGradient = LinearGradient(
    begin: Alignment.topLeft,
    end: Alignment.bottomRight,
    colors: [
      Color(0xFFFFEF96),
      Color(0xFFFFEF96).withOpacity(0.0),
    ],
  );

  static LinearGradient greenStripGradient = LinearGradient(
    begin: Alignment.topLeft,
    end: Alignment.bottomRight,
    colors: [
      Color(0xFFE5FFE1),
      Color(0xFFE5FFE1).withOpacity(0.0),
    ],
  );

  static const LinearGradient greyStripGradient = LinearGradient(
    begin: Alignment.topLeft,
    end: Alignment.bottomRight,
    colors: [
      Color(0xFFD7D7D7),
      Color(0xFFFFFFFF),
    ],
  );

  static const LinearGradient balanceCardGradientP = LinearGradient(
    begin: Alignment.topLeft,
    end: Alignment.bottomRight,
    colors: [
      Color(0xFFFF8940),
      Color(0xFFDB0000),
    ],
  );

  static const LinearGradient balanceCardGradientA = LinearGradient(
    begin: Alignment.topLeft,
    end: Alignment.bottomRight,
    colors: [
      Color(0xFF00BBDB),
      Color(0xFF4076FF),
    ],
  );

  static const LinearGradient balanceBarGradientP = LinearGradient(
    begin: Alignment.topCenter,
    end: Alignment.bottomCenter,
    colors: [
      Color(0xFFFF8940),
      Color(0xFFDB0000),
    ],
  );

  static const LinearGradient balanceBarGradientA = LinearGradient(
    begin: Alignment.topCenter,
    end: Alignment.bottomCenter,
    colors: [
      Color(0xFF00BBDB),
      Color(0xFF4076FF),
    ],
  );

  static const LinearGradient commonAppBarGradient = LinearGradient(
    begin: Alignment.topCenter,
    end: Alignment.bottomCenter,
    colors: [
      Color(0xFF04Bfef),
      Color(0xFF4076FF),
    ],
  );

  static LinearGradient whiteGradient = LinearGradient(

    colors: [

      Color(0xFFFFFFFF).withOpacity(0.0),
      Color(0xFFFFFFFF),
    ],
    begin: Alignment.bottomCenter,
    end: Alignment.topCenter,
  );
}