class DropDownsListResponse {
  String? error;
  GenDetails? genDetails;
  String? typeId;
  List<Categories>? categories;
  List<Descriptions>? descriptions;
  String? message;

  DropDownsListResponse({
    this.error,
    this.genDetails,
    this.typeId,
    this.categories,
    this.descriptions,
    this.message,
  });

  DropDownsListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error']?.toString();
    genDetails = json['gen_details'] != null
        ? GenDetails.fromJson(json['gen_details'])
        : null;
    typeId = json['type_id']?.toString();

    if (json['categories'] != null) {
      categories = List<Categories>.from(
          json['categories'].map((v) => Categories.fromJson(v)));
    }

    if (json['descriptions'] != null) {
      descriptions = List<Descriptions>.from(
          json['descriptions'].map((v) => Descriptions.fromJson(v)));
    }

    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = {};
    data['error'] = error;
    if (genDetails != null) {
      data['gen_details'] = genDetails!.toJson();
    }
    data['type_id'] = typeId;
    if (categories != null) {
      data['categories'] = categories!.map((v) => v.toJson()).toList();
    }
    if (descriptions != null) {
      data['descriptions'] = descriptions!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class GenDetails {
  String? id;
  String? hashId;
  String? prodName;
  String? modelName;
  String? amc;
  String? warranty;

  GenDetails({
    this.id,
    this.hashId,
    this.prodName,
    this.modelName,
    this.amc,
    this.warranty,
  });

  GenDetails.fromJson(Map<String, dynamic> json) {
    id = json['id']?.toString();
    hashId = json['hash_id']?.toString();
    prodName = json['prod_name'];
    modelName = json['model_name'];
    amc = json['amc']?.toString();
    warranty = json['warranty']?.toString();
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = {};
    data['id'] = id;
    data['hash_id'] = hashId;
    data['prod_name'] = prodName;
    data['model_name'] = modelName;
    data['amc'] = amc;
    data['warranty'] = warranty;
    return data;
  }
}

class Categories {
  String? id;
  String? name;

  Categories({this.id, this.name});

  Categories.fromJson(Map<String, dynamic> json) {
    id = json['id']?.toString();
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = {};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}

class Descriptions {
  String? id;
  String? name;

  Descriptions({this.id, this.name});

  Descriptions.fromJson(Map<String, dynamic> json) {
    id = json['id']?.toString();
    name = json['name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = {};
    data['id'] = id;
    data['name'] = name;
    return data;
  }
}
