import 'dart:convert';
import 'dart:io';
import 'package:flutter/material.dart';
import 'package:gen_service/Models/HelpAndComplaintModels/ComplaintListResponse.dart';
import 'package:gen_service/Models/TransactionModels/BillDetailResponse.dart';
import 'package:gen_service/Models/TransactionModels/PaymentDetailResponse.dart';
import '../Models/AuthResponse.dart';
import '../Models/CommonResponse.dart';
import '../Models/DashboardResponse.dart';
import '../Models/HelpAndComplaintModels/GeneratorListResponse.dart';
import '../Models/TransactionModels/TransactionListResponse.dart';
import '../Screens/HelpAndComplaintScreens/DropDownsListResponse.dart';
import 'api_URLs.dart';
import 'api_post_request.dart';
import 'package:http/http.dart' as http show MultipartFile;

class ApiCalling {

  /// Fetch gen service contact by mobile number
  static Future<FetchMobileResponse?> fetchRentalMobileApi(
      String mob,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "mob": mob,
      };
      final res = await post(data, fetchMobileUrl, {});

      if (res != null) {
        return FetchMobileResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error: $e");
      return null;
    }
  }

  static Future<FetchOTPResponse?> fetchMobileOtpApi(
      String mob,
      String otp,
      deviceDetails
      ) async {
    debugPrint("############################### Api fetch otpcalling ");
    try {
      Map<String, String> data = {
        "mob": mob,
        "otp": otp,
        "device_details": deviceDetails.toString(),
      };
      print(data);
      final res = await post(data, fetchOtpUrl, {});
      if (res != null) {
        print(res.body);
        return FetchOTPResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error: $e");
      return null;
    }
  }

  static Future<CommonResponse?> logoutApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, logoutUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Logout API Error: $e");
      return null;
    }
  }
/// fetch Dashboard Api
  static Future<DashboardResponse?> fetchDashboardApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, dashboardUrl, {});

      if (res != null) {
        return DashboardResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Dashboard API Error: $e");
      return null;
    }
  }

//___________________________________Transaction and payments
  /// fetch Transaction Api
  static Future<TransactionListResponse?> fetchTransactionListApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, transactionsUrl, {});

      debugPrint("Transaction response: ${res?.body}");

      if (res != null) {
        return TransactionListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Transaction API Error: $e");
      return null;
    }
  }

  /// fetch Payment Details Api
  static Future<PaymentDetailResponse?> fetchPaymentDetailApi(
      String accId,
      String sessionId,
      String billId
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "bill_id": billId,
      };
      final res = await post(data, paymentDetailUrl, {});

      debugPrint("Transaction response: ${res?.body}");

      if (res != null) {
        return PaymentDetailResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Payment Details API Error: $e");
      return null;
    }
  }


  /// fetch Bill Details Api
  static Future<BillDetailResponse?> fetchBillDetailApi(
      String accId,
      String sessionId,
      String billId
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "bill_id": billId,
      };
      final res = await post(data, billDetailUrl, {});

      debugPrint("Transaction response: ${res?.body}");

      if (res != null) {
        return BillDetailResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Bill Detail API Error: $e");
      return null;
    }
  }

//___________________________________Help and Complaints

  /// fetch Bill Details Api
  static Future<ComplaintListResponse?> fetchComplaintsListApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, complaintListUrl, {});

      debugPrint("Transaction response: ${res?.body}");

      if (res != null) {
        return ComplaintListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint list API Error: $e");
      return null;
    }
  }
/// add Complaints Api
  static Future<CommonResponse?> addComplaintApi(
      String accId,
      String sessionId,
      String genId,
      String categoryId,
      String descriptionId,
      String note,
      String typeId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "gen_id": genId,
        "category_id": categoryId,
        "description_id": descriptionId,
        "note": note,
        "type_id": typeId,
      };
      final res = await post(data, addComplaintUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Add Complaint API Error: $e");
      return null;
    }
  }

/// Generator list help Api calling
  static Future<GeneratorListResponse?> addGeneratorListApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, generatorListUrl, {});

      if (res != null) {
        return GeneratorListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Generator list API Error: $e");
      return null;
    }
  }

  /// Add complain dropdowns list
  static Future<DropDownsListResponse?> dropdownsListApi(
      String accId,
      String sessionId,
      String genId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "gen_id": genId,
      };
      final res = await post(data, complaintDropdownsUrl, {});

      if (res != null) {
        return DropDownsListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint dropdown list API Error: $e");
      return null;
    }
  }

  //
  // /// pay_amount
  // static Future<PayAmountResponse?> payAmountApi(
  //     String sessionId,
  //     String empId,
  //     String ammount,
  //     String refType,
  //     String refId,
  //     ) async {
  //   try {
  //     Map<String, String> data = {
  //       "session_id": sessionId,
  //       "acc_id": empId,
  //       "amount": ammount,
  //       "ref_type": refType,
  //       "ref_id": refId,
  //     };
  //
  //     final res = await post(data, payAmountUrl, {});
  //     debugPrint("PayAmount Response ${res?.body}");
  //
  //     if (res != null) {
  //       return PayAmountResponse.fromJson(jsonDecode(res.body));
  //     } else {
  //       debugPrint("Null Response");
  //       return null;
  //     }
  //   } catch (e) {
  //     debugPrint("❌ API Error (payAmountApi): $e");
  //     return null;
  //   }
  // }
  //


}
