class BillDetailResponse {
  String? error;
  BillDetails? billDetails;
  List<BillProducts>? billProducts;
  String? message;

  BillDetailResponse(
      {this.error, this.billDetails, this.billProducts, this.message});

  BillDetailResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    billDetails = json['bill_details'] != null
        ? new BillDetails.fromJson(json['bill_details'])
        : null;
    if (json['bill_products'] != null) {
      billProducts = <BillProducts>[];
      json['bill_products'].forEach((v) {
        billProducts!.add(new BillProducts.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.billDetails != null) {
      data['bill_details'] = this.billDetails!.toJson();
    }
    if (this.billProducts != null) {
      data['bill_products'] =
          this.billProducts!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    return data;
  }
}

class BillDetails {
  String? id;
  String? createdDate;
  String? compId;
  String? raisedAgainst;
  String? basicAmount;
  String? sgst;
  String? cgst;
  String? igst;
  String? totalAmount;
  String? balancePaymentAmount;

  BillDetails(
      {this.id,
        this.createdDate,
        this.compId,
        this.raisedAgainst,
        this.basicAmount,
        this.sgst,
        this.cgst,
        this.igst,
        this.totalAmount,
        this.balancePaymentAmount});

  BillDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createdDate = json['created_date'];
    compId = json['comp_id'];
    raisedAgainst = json['raised_against'];
    basicAmount = json['basic_amount'];
    sgst = json['sgst'];
    cgst = json['cgst'];
    igst = json['igst'];
    totalAmount = json['total_amount'];
    balancePaymentAmount = json['balance_payment_amount'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['created_date'] = this.createdDate;
    data['comp_id'] = this.compId;
    data['raised_against'] = this.raisedAgainst;
    data['basic_amount'] = this.basicAmount;
    data['sgst'] = this.sgst;
    data['cgst'] = this.cgst;
    data['igst'] = this.igst;
    data['total_amount'] = this.totalAmount;
    data['balance_payment_amount'] = this.balancePaymentAmount;
    return data;
  }
}

class BillProducts {
  String? id;
  String? partName;
  String? qty;
  String? price;
  String? totalPrice;

  BillProducts({this.id, this.partName, this.qty, this.price, this.totalPrice});

  BillProducts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    partName = json['part_name'];
    qty = json['qty'];
    price = json['price'];
    totalPrice = json['total_price'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['part_name'] = this.partName;
    data['qty'] = this.qty;
    data['price'] = this.price;
    data['total_price'] = this.totalPrice;
    return data;
  }
}
