class FetchMobileResponse {
  String? otp;
  String? error;
  String? message;

  FetchMobileResponse({this.otp, this.error, this.message});

  FetchMobileResponse.fromJson(Map<String, dynamic> json) {
    otp = json['otp'];
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['otp'] = this.otp;
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}


/// for Otp
class FetchOTPResponse {
  String? error;
  String? accId;
  String? sessionId;
  String? message;

  FetchOTPResponse({this.error, this.accId, this.sessionId, this.message});

  FetchOTPResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    accId = json['acc_id'];
    sessionId = json['session_id'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['acc_id'] = this.accId;
    data['session_id'] = this.sessionId;
    data['message'] = this.message;
    return data;
  }
}