class quotationListResponse {
  String? error;
  List<ServiceQuotation>? serviceQuotation;
  String? message;
  String? sessionExists;

  quotationListResponse(
      {this.error, this.serviceQuotation, this.message, this.sessionExists});

  quotationListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['service_quotation'] != null) {
      serviceQuotation = <ServiceQuotation>[];
      json['service_quotation'].forEach((v) {
        serviceQuotation!.add(new ServiceQuotation.fromJson(v));
      });
    }
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.serviceQuotation != null) {
      data['service_quotation'] =
          this.serviceQuotation!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class ServiceQuotation {
  String? id;
  String? title;
  String? date;
  String? fileLoc;

  ServiceQuotation({this.id, this.title, this.date, this.fileLoc});

  ServiceQuotation.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    title = json['title'];
    date = json['date'];
    fileLoc = json['file_loc'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['title'] = this.title;
    data['date'] = this.date;
    data['file_loc'] = this.fileLoc;
    return data;
  }
}
