class GetInTouchListResponse {
  String? error;
  List<GetInTouchList>? getInTouchList;
  String? message;
  String? sessionExists;

  GetInTouchListResponse(
      {this.error, this.getInTouchList, this.message, this.sessionExists});

  GetInTouchListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['get_in_touch_list'] != null) {
      getInTouchList = <GetInTouchList>[];
      json['get_in_touch_list'].forEach((v) {
        getInTouchList!.add(new GetInTouchList.fromJson(v));
      });
    }
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.getInTouchList != null) {
      data['get_in_touch_list'] =
          this.getInTouchList!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class GetInTouchList {
  String? id;
  String? branchName;
  String? googleReviewLink;
  String? googleMapLink;
  String? address;
  String? loc;
  String? stateName;
  String? telephoneNo;
  String? mail;
  String? latitude;
  String? longitude;

  GetInTouchList(
      {this.id,
        this.branchName,
        this.googleReviewLink,
        this.googleMapLink,
        this.address,
        this.loc,
        this.stateName,
        this.telephoneNo,
        this.mail,
        this.latitude,
        this.longitude});

  GetInTouchList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    branchName = json['branch_name'];
    googleReviewLink = json['google_review_link'];
    googleMapLink = json['google_map_link'];
    address = json['address'];
    loc = json['loc'];
    stateName = json['state_name'];
    telephoneNo = json['telephone_no'];
    mail = json['mail'];
    latitude = json['latitude'];
    longitude = json['longitude'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['branch_name'] = this.branchName;
    data['google_review_link'] = this.googleReviewLink;
    data['google_map_link'] = this.googleMapLink;
    data['address'] = this.address;
    data['loc'] = this.loc;
    data['state_name'] = this.stateName;
    data['telephone_no'] = this.telephoneNo;
    data['mail'] = this.mail;
    data['latitude'] = this.latitude;
    data['longitude'] = this.longitude;
    return data;
  }
}
