class PaymentDetailResponse {
  String? error;
  PaymentDetails? paymentDetails;
  String? message;

  PaymentDetailResponse({this.error, this.paymentDetails, this.message});

  PaymentDetailResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    paymentDetails = json['payment_details'] != null
        ? new PaymentDetails.fromJson(json['payment_details'])
        : null;
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.paymentDetails != null) {
      data['payment_details'] = this.paymentDetails!.toJson();
    }
    data['message'] = this.message;
    return data;
  }
}

class PaymentDetails {
  String? id;
  String? datetime;
  String? amount;
  String? mode;
  String? refNo;
  String? remainBalance;

  PaymentDetails(
      {this.id,
        this.datetime,
        this.amount,
        this.mode,
        this.refNo,
        this.remainBalance});

  PaymentDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    datetime = json['datetime'];
    amount = json['amount'];
    mode = json['mode'];
    refNo = json['ref_no'];
    remainBalance = json['remain_balance'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['datetime'] = this.datetime;
    data['amount'] = this.amount;
    data['mode'] = this.mode;
    data['ref_no'] = this.refNo;
    data['remain_balance'] = this.remainBalance;
    return data;
  }
}
