import 'package:flutter/material.dart';
import 'package:gen_service/Notifiers/AuthProvider.dart';
import 'package:gen_service/Notifiers/TransactionsProvider.dart';
import 'package:provider/provider.dart';

import 'Notifiers/ContactUsProvider.dart';
import 'Notifiers/DashboardProvider.dart';
import 'Notifiers/HelpAndComplaintProvider.dart';
import 'Notifiers/PayAmountProvider.dart';
import 'Notifiers/generatorDetailsProvider.dart';
import 'Notifiers/theme_provider.dart';
import 'Screens/AuthScreen/LoginScreen.dart';
import 'Screens/SplashScreen.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MultiProvider(
      providers: [
        ChangeNotifierProvider(create: (_) => AuthProvider()),
        ChangeNotifierProvider<ThemeProvider>(create: (_) => ThemeProvider(),),
        ChangeNotifierProvider(create: (_) => DashboardProvider()),
        ChangeNotifierProvider(create: (_) => TransactionsProvider()),
        ChangeNotifierProvider(create: (_) => HelpAndComplaintProvider()),
        ChangeNotifierProvider(create: (_) => Generatordetailsprovider()),
        ChangeNotifierProvider(create: (_) => ContactUsProvider()),
        ChangeNotifierProvider(create: (_) => PayAmountProvider()),
      ],
      child: Consumer<ThemeProvider>(
        builder: (context, themeProvider, child) {
          return MaterialApp(
            debugShowCheckedModeBanner: false,
            title: 'Gen Services',
            theme: ThemeData(
              fontFamily: 'Poppins',
            ),
            home: SplashScreen(),
          );
        },
      ),
    );
  }
}

