import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:provider/provider.dart';

import '../Notifiers/generatorDetailsProvider.dart';
import '../Utility/AppColors.dart';

class QuotationListScreen extends StatefulWidget {
  final accId;
  final sessionId;
  final genId;

  const QuotationListScreen({
    super.key,
    required this.accId,
    required this.sessionId,
    required this.genId,
  });

  @override
  State<QuotationListScreen> createState() => _QuotationListScreenState();
}

class _QuotationListScreenState extends State<QuotationListScreen> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<Generatordetailsprovider>(
        context,
        listen: false,
      );
      provider.fetchQuotationList(widget.accId, widget.sessionId, widget.genId);
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Generatordetailsprovider>(
      builder: (context, provider, child) {
        final isLoading = provider.isLoading;
        final error = provider.errorMessage;
        final response = provider.quotationResponse;

        final data = response?.serviceQuotation ?? [];

        if (isLoading) {
          return const Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(
              child: CircularProgressIndicator(color: AppColors.buttonColor),
            ),
          );
        }

        if (error != null) {
          return Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(
              child: Text(
                error,
                style: const TextStyle(color: Colors.red, fontSize: 16),
              ),
            ),
          );
        }

        if (data == null) {
          return const Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: Center(child: Text("No data found.")),
          );
        }
        return RefreshIndicator.adaptive(
          color: AppColors.amountText,
          onRefresh: () async {
            await Future.delayed(const Duration(milliseconds: 600));
          },

          child: Scaffold(
            backgroundColor: AppColors.backgroundRegular,
            body: CustomScrollView(
              physics: const BouncingScrollPhysics(),
              slivers: [
                SliverAppBar(
                  stretch: true,
                  pinned: true,
                  expandedHeight: 75,
                  backgroundColor: AppColors.backgroundRegular,
                  elevation: 0,
                  // Remove shadow
                  automaticallyImplyLeading: false,
                  toolbarHeight: 0,
                  // Remove toolbar space
                  collapsedHeight: 0,
                  // Completely collapse to 0 height
                  flexibleSpace: FlexibleSpaceBar(
                    stretchModes: const [StretchMode.fadeTitle],
                    background: Container(
                      decoration: BoxDecoration(
                        gradient: AppColors.balanceBarGradientA,
                      ),
                      child: SafeArea(
                        child: Padding(
                          padding: const EdgeInsets.symmetric(
                            horizontal: 16,
                            vertical: 20,
                          ),
                          child: SizedBox(
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                InkResponse(
                                  onTap: () {
                                    HapticFeedback.selectionClick();

                                    Navigator.pop(context, true);
                                  },
                                  child: SvgPicture.asset(
                                    "assets/svg/appbar_back.svg",
                                    height: 25,
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(
                                  flex: 4,
                                  child: InkResponse(
                                    onTap: () {
                                      HapticFeedback.selectionClick();

                                      Navigator.pop(context, true);
                                    },
                                    child: Text(
                                      "Quotations List",
                                      overflow: TextOverflow.ellipsis,
                                      maxLines: 1,
                                      style: TextStyle(
                                        fontSize: 16,
                                        color: Colors.white,
                                        height: 1.1,
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                    ),
                  ),
                ),

                SliverToBoxAdapter(
                  child: Container(
                    color: Color(0xFF4076FF),
                    child: Container(
                      decoration: const BoxDecoration(
                        color: AppColors.backgroundRegular,
                        borderRadius: BorderRadius.only(
                          topLeft: Radius.circular(30),
                          topRight: Radius.circular(30),
                        ),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          SizedBox(height: 4),

                          ListView.builder(
                            shrinkWrap: true,
                            physics: const NeverScrollableScrollPhysics(),
                            itemCount: data!.length,
                            itemBuilder: (context, j) {
                              return Container(
                                padding: const EdgeInsets.symmetric(
                                  vertical: 10,
                                  horizontal: 10,
                                ),
                                margin: const EdgeInsets.symmetric(
                                  vertical: 5,
                                  horizontal: 10,
                                ),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(12),
                                ),
                                child: Row(
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceBetween,
                                  children: [
                                    Expanded(
                                      flex: 2,
                                      child: Text(
                                        data[j].title ?? "-",
                                        maxLines: 2,
                                        overflow: TextOverflow.ellipsis,
                                      ),
                                    ),
                                    Spacer(),
                                    Expanded(
                                      flex: 1,
                                      child: Text(
                                        data[j].date ?? "-",
                                        textAlign: TextAlign.right,
                                        style: TextStyle(),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            },
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}
