import 'package:flutter/foundation.dart';

import '../Models/GetInTouchListResponse.dart';
import '../Services/api_calling.dart';

class ContactUsProvider extends ChangeNotifier {
  /// 🔹 State Variables
  bool _isLoading = false;
  String? _errorMessage;
  GetInTouchListResponse? _response;

  /// 🔹 Getters
  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;
  GetInTouchListResponse? get response => _response;
  List<GetInTouchList>? get contactList => _response?.getInTouchList;

  /// 🔹 Internal Setter for Loading State
  void _setLoading(bool value) {
    _isLoading = value;
    notifyListeners();
  }

  /// 🔹 Fetch Contact Us / Get In Touch List API
  Future<void> fetchContactUs(String accId, String sessionId) async {
    _setLoading(true);
    _errorMessage = null;

    try {
      debugPrint("📡 Fetching Get In Touch list...");
      final res = await ApiCalling.fetchGetInTouchListApi(accId, sessionId);
      _response = res;

      if (res == null) {
        _errorMessage = "No response from server.";
      } else if (res.error?.toString().trim() != "0") {
        _errorMessage = res.message?.trim().isNotEmpty == true
            ? res.message
            : "Something went wrong. Please try again.";
      }
    } catch (e) {
      debugPrint("❌ ContactUsProvider Error: $e");
      _errorMessage = "An unexpected error occurred. Please try again.";
    } finally {
      _setLoading(false);
    }
  }

  /// 🔹 Optional: Refresh list (shortcut method)
  Future<void> refresh(String accId, String sessionId) async {
    await fetchContactUs(accId, sessionId);
  }

  /// 🔹 Clear data (useful when logging out or leaving screen)
  void clearData() {
    _response = null;
    _errorMessage = null;
    notifyListeners();
  }
}
