class TransactionListResponse {
  String? error;
  String? balanceAmount;
  String? balanceType;
  String? totalCredit;
  String? totalDebit;
  Map<String, List<TransactionItem>>? transactions;
  String? message;

  TransactionListResponse({
    this.error,
    this.balanceAmount,
    this.balanceType,
    this.totalCredit,
    this.totalDebit,
    this.transactions,
    this.message,
  });

  TransactionListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    balanceAmount = json['balance_amount'];
    balanceType = json['balance_type'];
    totalCredit = json['total_credit'];
    totalDebit = json['total_debit'];
    message = json['message'];

    if (json['transactions'] != null) {
      transactions = {};
      json['transactions'].forEach((key, value) {
        transactions![key] = List<TransactionItem>.from(
          value.map((v) => TransactionItem.fromJson(v)),
        );
      });
    }
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['error'] = error;
    data['balance_amount'] = balanceAmount;
    data['balance_type'] = balanceType;
    data['total_credit'] = totalCredit;
    data['total_debit'] = totalDebit;
    data['message'] = message;
    if (transactions != null) {
      data['transactions'] = transactions!.map((key, value) =>
          MapEntry(key, value.map((v) => v.toJson()).toList()));
    }
    return data;
  }
}

class TransactionItem {
  String? id;
  String? billId;
  String? atype;
  String? type;
  String? datetime;
  String? cAmount;
  String? dAmount;
  String? narration;

  TransactionItem({
    this.id,
    this.billId,
    this.atype,
    this.type,
    this.datetime,
    this.cAmount,
    this.dAmount,
    this.narration,
  });

  TransactionItem.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    billId = json['bill_id'];
    atype = json['atype'];
    type = json['type'];
    datetime = json['datetime'];
    cAmount = json['c_amount'];
    dAmount = json['d_amount'];
    narration = json['narration'];
  }

  Map<String, dynamic> toJson() => {
    'id': id,
    'bill_id': billId,
    'atype': atype,
    'type': type,
    'datetime': datetime,
    'c_amount': cAmount,
    'd_amount': dAmount,
    'narration': narration,
  };
}
