import 'package:flutter/cupertino.dart';
import 'package:gen_service/Services/api_calling.dart';

import '../Models/TransactionModels/BillDetailResponse.dart';
import '../Models/TransactionModels/PaymentDetailResponse.dart';
import '../Models/TransactionModels/TransactionListResponse.dart';

class TransactionsProvider with ChangeNotifier {
  bool _isLoading = false;
  String? _errorMessage;
  TransactionListResponse? _transactionList;

  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;
  TransactionListResponse? get transactionList => _transactionList;

  /// Fetch Transactions from API
  Future<void> fetchTransactions(String accId, String sessionId) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();

    try {
      final response = await ApiCalling.fetchTransactionListApi(accId, sessionId);

      if (response != null) {
        _transactionList = response;
        _errorMessage = null;
      } else {
        _errorMessage = "No response from server";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch transactions: $e";
    }

    _isLoading = false;
    notifyListeners();
  }

  /// Clear Data
  void clearTransactions() {
    _transactionList = null;
    _errorMessage = null;
    notifyListeners();
  }



  // Payment Detail properties
  bool _isPaymentLoading = false;
  PaymentDetailResponse? _paymentDetail;

  bool get isPaymentLoading => _isPaymentLoading;
  PaymentDetailResponse? get paymentDetail => _paymentDetail;

  // Bill Detail properties
  bool _isBillLoading = false;
  BillDetailResponse? _billDetail;

  bool get isBillLoading => _isBillLoading;
  BillDetailResponse? get billDetail => _billDetail;


  // 🔹 Fetch Payment Detail API
  Future<void> fetchPaymentDetails(
      String accId, String sessionId, String billId) async {
    _isPaymentLoading = true;
    notifyListeners();

    try {
      final response =
      await ApiCalling.fetchPaymentDetailApi(accId, sessionId, billId);

      if (response != null) {
        _paymentDetail = response;
      } else {
        debugPrint("No payment detail response");
      }
    } catch (e) {
      debugPrint("❌ Payment Details Error: $e");
    }

    _isPaymentLoading = false;
    notifyListeners();
  }

  // ---------------------------------------------------------------------------
  // 🔹 Fetch Bill Detail API
  Future<void> fetchBillDetails(
      String accId, String sessionId, String billId) async {
    _isBillLoading = true;
    notifyListeners();

    try {
      final response =
      await ApiCalling.fetchBillDetailApi(accId, sessionId, billId);

      if (response != null) {
        _billDetail = response;
      } else {
        debugPrint("No bill detail response");
      }
    } catch (e) {
      debugPrint("❌ Bill Details Error: $e");
    }

    _isBillLoading = false;
    notifyListeners();
  }

  // ---------------------------------------------------------------------------
  // 🔹 Clear All Data (optional helper)
  void clearAll() {
    _transactionList = null;
    _paymentDetail = null;
    _billDetail = null;
    _errorMessage = null;
    notifyListeners();
  }

}
