import 'package:android_id/android_id.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:device_info_plus/device_info_plus.dart';

import 'dart:io';
import 'package:android_id/android_id.dart';
import '../Models/AuthResponse.dart';
import '../Models/CommonResponse.dart';
import '../Services/api_calling.dart';



class AuthProvider with ChangeNotifier {
  bool _isLoading = false;
  bool get isLoading => _isLoading;

  FetchMobileResponse? _mobileResponse;
  FetchMobileResponse? get mobileResponse => _mobileResponse;

  FetchOTPResponse? _otpResponse;
  FetchOTPResponse? get otpResponse => _otpResponse;

  CommonResponse? _logoutResponse;
  CommonResponse? get logoutResponse => _logoutResponse;

  String _deviceDetails = "";
  String _deviceId = "";
  String _androidId = 'Unknown';
  static const _androidIdPlugin = AndroidId();


  String get deviceId => _deviceId;
  String get deviceDetails => _deviceDetails;


  void _setLoading(bool value) {
    _isLoading = value;
    notifyListeners();
  }


  Future<void> initAndroidId() async {

    String androidId;
    var deviceInfo = DeviceInfoPlugin(); // import 'dart:io'
    var androidDeviceInfo = await deviceInfo.androidInfo;
    _deviceDetails = await "Version Name: " +
        androidDeviceInfo.version.baseOS.toString().trim() +
        ", " +
        "Version Code: " +
        androidDeviceInfo.version.codename.toString().trim() +
        ", " +
        "OS Version: " +
        androidDeviceInfo.version.codename.toString().trim() +
        ", SDK Version: " +
        androidDeviceInfo.version.sdkInt.toString().trim() +
        ", Device: " +
        androidDeviceInfo.device.toString().trim() +
        ", Model: " +
        androidDeviceInfo.model.toString().trim() +
        ", Product: " +
        androidDeviceInfo.product.toString().trim() +
        ", Manufacturer: " +
        androidDeviceInfo.manufacturer.toString().trim() +
        ", Brand: " +
        androidDeviceInfo.brand.toString().trim() +
        ", User: " +
        androidDeviceInfo.data['user'].toString().trim() +
        ", Display: " +
        androidDeviceInfo.display.toString().trim() +
        ", Hardware: " +
        androidDeviceInfo.hardware.toString().trim() +
        ", Board: " +
        androidDeviceInfo.board.toString().trim() +
        ", Host: " +
        androidDeviceInfo.host.toString().trim() +
        ", Serial: " +
        //androidDeviceInfo.serialNumber.toString().trim() +
        ", ID: " +
        androidDeviceInfo.id.toString().trim() +
        ", Bootloader: " +
        androidDeviceInfo.bootloader.toString().trim() +
        ", CPU ABI1: " +
        androidDeviceInfo.supported64BitAbis.toString().trim() +
        ", CPU ABI2: " +
        androidDeviceInfo.supported64BitAbis.toString().trim() +
        ", FingerPrint: " +
        androidDeviceInfo.fingerprint.toString().trim();
    try {
      androidId = await _androidIdPlugin.getId() ?? 'Unknown ID';
      _deviceId = androidId;
      debugPrint("testing" + deviceId);
      debugPrint(_deviceDetails.toString());
    } on PlatformException {
      androidId = 'Failed to get Android ID.';
    }
    _androidId = androidId;
    print(_deviceDetails);
    print(_deviceId);
    print(_androidId);
    notifyListeners();
  }

  Future<String?> getDevId() async {
    var deviceInfo = DeviceInfoPlugin(); // import 'dart:io'
    var iosDeviceInfo = await deviceInfo.iosInfo;
    _deviceId = iosDeviceInfo.identifierForVendor!;
    _deviceDetails = iosDeviceInfo.toString();
    notifyListeners();
  }

  /// 🔹 Fetch OTP by Mobile Number
  Future<void> fetchMobile(String mobile) async {
    _setLoading(true);
    try {
      final res = await ApiCalling.fetchRentalMobileApi(mobile);
      _mobileResponse = res;
      notifyListeners();
    } catch (e) {
      debugPrint("❌ fetchMobile Provider Error: $e");
    } finally {
      _setLoading(false);
    }
  }

  /// 🔹 Verify OTP API
  Future<void> verifyOtp(String mobile, String otp, ) async {
    _setLoading(true);
    try {
      final res = await ApiCalling.fetchMobileOtpApi(mobile, otp, deviceDetails??"");
      _otpResponse = res;
      notifyListeners();
    } catch (e) {
      debugPrint("❌ verifyOtp Provider Error: $e");
    } finally {
      _setLoading(false);
    }
  }

  /// 🔹 Logout API
  Future<void> logout(String accId, String sessionId) async {
    _setLoading(true);
    try {
      final res = await ApiCalling.logoutApi(accId, sessionId);
      _logoutResponse = res;
      notifyListeners();
    } catch (e) {
      debugPrint("❌ logout Provider Error: $e");
    } finally {
      _setLoading(false);
    }
  }
}
