class ProfileDataResponse {
  String? error;
  Details? details;
  String? message;
  String? sessionExists;

  ProfileDataResponse(
      {this.error, this.details, this.message, this.sessionExists});

  ProfileDataResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    details =
    json['details'] != null ? new Details.fromJson(json['details']) : null;
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.details != null) {
      data['details'] = this.details!.toJson();
    }
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class Details {
  String? name;
  String? mobNum;
  String? email;
  String? address;
  String? profileImg;
  String? state;
  String? locality;

  Details(
      {this.name,
        this.mobNum,
        this.email,
        this.address,
        this.profileImg,
        this.state,
        this.locality});

  Details.fromJson(Map<String, dynamic> json) {
    name = json['name'];
    mobNum = json['mob_num'];
    email = json['email'];
    address = json['address'];
    profileImg = json['profile_img'];
    state = json['state'];
    locality = json['locality'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['name'] = this.name;
    data['mob_num'] = this.mobNum;
    data['email'] = this.email;
    data['address'] = this.address;
    data['profile_img'] = this.profileImg;
    data['state'] = this.state;
    data['locality'] = this.locality;
    return data;
  }
}
