// import 'package:flutter/material.dart';
// import 'package:flutter/services.dart';
// import 'package:flutter_svg/svg.dart';
// import 'package:provider/provider.dart';
//
// import '../Notifiers/generatorDetailsProvider.dart';
// import '../Utility/AppColors.dart';
//
// class ComplaintListScreen extends StatefulWidget {
//   final accId;
//   final sessionId;
//   const ComplaintListScreen({super.key,required this.accId,required this.sessionId});
//
//   @override
//   State<ComplaintListScreen> createState() => _ComplaintListScreenState();
// }
//
// class _ComplaintListScreenState extends State<ComplaintListScreen> {
//   @override
//   void initState() {
//     // TODO: implement initState
//     super.initState();
//     WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
//       final provider = Provider.of<Generatordetailsprovider>(
//         context,
//         listen: false,
//       );
//       provider.fetchComplaintList(widget.accId, widget.sessionId);
//     });
//   }
//
//   @override
//   Widget build(BuildContext context) {
//     return Consumer<Generatordetailsprovider>(
//       builder: (context, provider, child) {
//         final isLoading = provider.isLoading;
//         final error = provider.errorMessage;
//         final response = provider.complaintResponse;
//
//         final data = response?.complaintList??[];
//
//         if (isLoading) {
//           return const Scaffold(
//             backgroundColor: AppColors.backgroundRegular,
//             body: Center(
//               child: CircularProgressIndicator(color: AppColors.buttonColor),
//             ),
//           );
//         }
//
//         if (error != null) {
//           return Scaffold(
//             backgroundColor: AppColors.backgroundRegular,
//             body: Center(
//               child: Text(
//                 error,
//                 style: const TextStyle(color: Colors.red, fontSize: 16),
//               ),
//             ),
//           );
//         }
//
//         if (data == null) {
//           return const Scaffold(
//             backgroundColor: AppColors.backgroundRegular,
//             body: Center(child: Text("No data found.")),
//           );
//         }
//         return RefreshIndicator.adaptive(
//           color: AppColors.amountText,
//           onRefresh: () async {
//             await Future.delayed(const Duration(milliseconds: 600));
//           },
//
//           child: Scaffold(
//             backgroundColor: AppColors.backgroundRegular,
//             body: CustomScrollView(
//               physics: const BouncingScrollPhysics(),
//               slivers: [
//                 SliverAppBar(
//                   stretch: true,
//                   pinned: true,
//                   expandedHeight: 75,
//                   backgroundColor: AppColors.backgroundRegular,
//                   elevation: 0,
//                   // Remove shadow
//                   automaticallyImplyLeading: false,
//                   toolbarHeight: 0,
//                   // Remove toolbar space
//                   collapsedHeight: 0,
//                   // Completely collapse to 0 height
//                   flexibleSpace: FlexibleSpaceBar(
//                     stretchModes: const [StretchMode.fadeTitle],
//                     background: Container(
//                       decoration: BoxDecoration(
//                         gradient: AppColors.balanceBarGradientA,
//                       ),
//                       child: SafeArea(
//                         child: Padding(
//                           padding: const EdgeInsets.symmetric(
//                             horizontal: 16,
//                             vertical: 20,
//                           ),
//                           child: SizedBox(
//                             child: Row(
//                               mainAxisAlignment: MainAxisAlignment.start,
//                               crossAxisAlignment: CrossAxisAlignment.center,
//                               children: [
//                                 InkResponse(
//                                   onTap: () {
//                                     HapticFeedback.selectionClick();
//
//                                     Navigator.pop(context, true);
//                                   },
//                                   child: SvgPicture.asset(
//                                     "assets/svg/appbar_back.svg",
//                                     height: 25,
//                                   ),
//                                 ),
//                                 SizedBox(width: 10),
//                                 Expanded(
//                                   flex: 4,
//                                   child: InkResponse(
//                                     onTap: () {
//                                       HapticFeedback.selectionClick();
//
//                                       Navigator.pop(context, true);
//                                     },
//                                     child: Text(
//                                       "Complaint List",
//                                       overflow: TextOverflow.ellipsis,
//                                       maxLines: 1,
//                                       style: TextStyle(
//                                         fontSize: 16,
//                                         color: Colors.white,
//                                         height: 1.1,
//                                       ),
//                                     ),
//                                   ),
//                                 ),
//                               ],
//                             ),
//                           ),
//                         ),
//                       ),
//                     ),
//                   ),
//                 ),
//
//                 SliverToBoxAdapter(
//                   child: Container(
//                     color: Color(0xFF4076FF),
//                     child: Container(
//                       decoration: const BoxDecoration(
//                         color: AppColors.backgroundRegular,
//                         borderRadius: BorderRadius.only(
//                           topLeft: Radius.circular(30),
//                           topRight: Radius.circular(30),
//                         ),
//                       ),
//                       child: Column(
//                         crossAxisAlignment: CrossAxisAlignment.start,
//                         children: [
//                           SizedBox(height: 4),
//
//                           ListView.builder(
//                             shrinkWrap: true,
//                             physics: const NeverScrollableScrollPhysics(),
//                             itemCount: data!.length,
//                             itemBuilder: (context, j) {
//                               return Container(
//                                 padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 10),
//                                 margin: const EdgeInsets.symmetric(vertical: 5, horizontal: 10),
//                                 decoration: BoxDecoration(
//                                   color: Colors.white,
//                                   borderRadius: BorderRadius.circular(14),
//                                 ),
//                                 child: Column(
//                                   children: [
//                                     Row(
//                                       mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                                       children: [
//                                         Expanded(
//                                           flex: 7,
//                                           child: SizedBox(
//                                             child: Column(
//                                               crossAxisAlignment: CrossAxisAlignment.start,
//                                               children: [
//                                                 RichText(
//                                                   text: TextSpan(
//                                                     style: const TextStyle(
//                                                       fontFamily: 'Poppins',
//                                                       color: Color(0xFF008CDE),
//                                                       fontSize: 14,
//                                                     ),
//                                                     children: [
//                                                       TextSpan(text: "#${data[j].id}"),
//                                                       TextSpan(text: " | ${data[j].complaintName}"),
//                                                     ],
//                                                   ),
//                                                 ),
//                                                 Text(
//                                                   "${data[j].registredDate}",
//                                                   style: TextStyle(
//                                                     color: AppColors.subtitleText,
//                                                     fontSize: 12,
//                                                   ),
//                                                 ),
//                                               ],
//                                             ),
//                                           ),
//                                         ),
//
//                                         Expanded(
//                                           flex: 3,
//                                           child: Container(
//                                             padding: EdgeInsets.symmetric(vertical: 6, horizontal: 10),
//                                             decoration: BoxDecoration(
//                                               borderRadius: BorderRadius.circular(8),
//                                               color: AppColors.successBG,
//                                             ),
//                                             child: Center(
//                                               child: Text(
//                                                 "${data[j].openStatus}",
//                                                 style: TextStyle(fontSize: 14, color: AppColors.success),
//                                               ),
//                                             ),
//                                           ),
//                                         ),
//                                       ],
//                                     ),
//                                     Divider(color: Color(0xFF777777), thickness: 0.3),
//                                     Row(
//                                       mainAxisAlignment: MainAxisAlignment.spaceBetween,
//                                       crossAxisAlignment: CrossAxisAlignment.start,
//                                       children: [
//                                         Expanded(
//                                           flex: 5,
//                                           child: Text(
//                                             "${data[j].productName}",
//                                             overflow: TextOverflow.ellipsis,
//                                             maxLines: 2,
//                                             style: const TextStyle(
//                                               color: AppColors.nearDarkText,
//                                               fontSize: 12,
//                                             ),
//                                           ),
//                                         ),
//                                         Expanded(
//                                           flex: 5,
//                                           child: RichText(
//                                             maxLines: 1,
//                                             textAlign: TextAlign.right,
//                                             text: TextSpan(
//                                               style: TextStyle(
//                                                 fontFamily: 'Poppins',
//                                                 color: AppColors.subtitleText,
//                                                 fontSize: 12,
//                                               ),
//                                               children: [
//                                                 TextSpan(text: "#${data[j].hashId}"),
//                                                 TextSpan(text: " | Engine: ${data[j].modelName}"),
//                                               ],
//                                             ),
//                                           ),
//                                         ),
//                                       ],
//                                     ),
//                                   ],
//                                 ),
//                               );
//                             },
//                           ),
//                         ],
//                       ),
//                     ),
//                   ),
//                 ),
//               ],
//             ),
//           ),
//         );
//       },
//     );
//   }
// }
