class allJobCardListResponse {
  String? error;
  List<JobCardList>? jobCardList;
  String? message;

  allJobCardListResponse({this.error, this.jobCardList, this.message});

  allJobCardListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['job_card_list'] != null) {
      jobCardList = <JobCardList>[];
      json['job_card_list'].forEach((v) {
        jobCardList!.add(new JobCardList.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.jobCardList != null) {
      data['job_card_list'] = this.jobCardList!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    return data;
  }
}

class JobCardList {
  String? id;
  String? complaintId;
  String? extraDescription;
  String? date;
  String? totalPrice;

  JobCardList(
      {this.id,
        this.complaintId,
        this.extraDescription,
        this.date,
        this.totalPrice});

  JobCardList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    complaintId = json['complaint_id'];
    extraDescription = json['extra_description'];
    date = json['date'];
    totalPrice = json['total_price'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['complaint_id'] = this.complaintId;
    data['extra_description'] = this.extraDescription;
    data['date'] = this.date;
    data['total_price'] = this.totalPrice;
    return data;
  }
}
