import 'dart:convert';
import 'dart:io';
import 'package:flutter/material.dart';
import 'package:gen_service/Models/GetInTouchListResponse.dart';
import 'package:gen_service/Models/HelpAndComplaintModels/ComplaintListResponse.dart';
import 'package:gen_service/Models/HelpAndComplaintModels/allJobCardListResponse.dart';
import 'package:gen_service/Models/HelpAndComplaintModels/allServiceListResponse.dart';
import 'package:gen_service/Models/HelpAndComplaintModels/jobCardProductsResponse.dart';
import 'package:gen_service/Models/ProfileDataResponse.dart';
import 'package:gen_service/Models/TransactionModels/BillDetailResponse.dart';
import 'package:gen_service/Models/TransactionModels/PaymentDetailResponse.dart';
import 'package:gen_service/Models/amcQuotationListResponse.dart';
import 'package:gen_service/Models/complaintListResponse.dart';
import 'package:gen_service/Models/generatorDetailsResponse.dart';
import 'package:gen_service/Models/quotationListResponse.dart';
import 'package:gen_service/Models/ratingResponse.dart';
import 'package:gen_service/Models/scheduleListResponse.dart';
import '../Models/AuthResponse.dart';
import '../Models/CommonResponse.dart';
import '../Models/DashboardResponse.dart';
import '../Models/HelpAndComplaintModels/GeneratorListResponse.dart';
import '../Models/HelpAndComplaintModels/complaintDetailsResponse.dart';
import '../Models/TransactionModels/PayAmountResponse.dart';
import '../Models/TransactionModels/TransactionListResponse.dart';
import '../Models/HelpAndComplaintModels/DropDownsListResponse.dart';
import '../Notifiers/PayAmountProvider.dart';
import 'api_URLs.dart';
import 'api_post_request.dart';
import 'package:http/http.dart' as http show MultipartFile;

class ApiCalling {

  /// Fetch gen service contact by mobile number
  static Future<FetchMobileResponse?> fetchRentalMobileApi(
      String mob,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "mob": mob,
      };
      final res = await post(data, fetchMobileUrl, {});

      if (res != null) {
        return FetchMobileResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error: $e");
      return null;
    }
  }

  static Future<FetchOTPResponse?> fetchMobileOtpApi(
      String mob,
      String otp,
      deviceDetails
      ) async {
    debugPrint("############################### Api fetch otpcalling ");
    try {
      Map<String, String> data = {
        "mob": mob,
        "otp": otp,
        "device_details": deviceDetails.toString(),
      };
      print(data);
      final res = await post(data, fetchOtpUrl, {});
      if (res != null) {
        print(res.body);
        return FetchOTPResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error: $e");
      return null;
    }
  }

  static Future<ProfileDataResponse?> fetchProfileDataApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, profileDetailsUrl, {});

      if (res != null) {
        return ProfileDataResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Profile API Error: $e");
      return null;
    }
  }

  static Future<CommonResponse?> logoutApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("########logout Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, logoutUrl, {});
      debugPrint("Response ${res?.body}");
      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Logout API Error: $e");
      return null;
    }
  }
/// fetch Dashboard Api
  static Future<DashboardResponse?> fetchDashboardApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, dashboardUrl, {});

      if (res != null) {
        return DashboardResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Dashboard API Error: $e");
      return null;
    }
  }

//___________________________________Transaction and payments
  /// fetch Transaction Api
  static Future<TransactionListResponse?> fetchTransactionListApi(
      String accId,
      String sessionId,
      page_number
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "page_number":page_number
      };
      final res = await post(data, transactionsUrl, {});

      debugPrint("Transaction response: ${res?.body}");

      if (res != null) {
        return TransactionListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Transaction API Error: $e");
      return null;
    }
  }

  /// fetch Payment Details Api
  static Future<PaymentDetailResponse?> fetchPaymentDetailApi(
      String accId,
      String sessionId,
      String billId
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "bill_id": billId,
      };
      final res = await post(data, paymentDetailUrl, {});

      debugPrint("Transaction response: ${res?.body}");

      if (res != null) {
        return PaymentDetailResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Payment Details API Error: $e");
      return null;
    }
  }


  /// fetch Bill Details Api
  static Future<BillDetailResponse?> fetchBillDetailApi(
      String accId,
      String sessionId,
      String billId
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "bill_id": billId,
      };
      final res = await post(data, billDetailUrl, {});

      debugPrint("Transaction response: ${res?.body}");

      if (res != null) {
        return BillDetailResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Bill Detail API Error: $e");
      return null;
    }
  }
  ///  Bill Download api
  static Future<CommonResponse?> billDownloadApi(
      String sessionId,
      String empId,
      String accId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "bill_id": empId,
        "acc_id": accId,
      };

      final res = await post(data, downloadBillUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (billDownload): $e");
      return null;
    }
  }

  ///  Payment Receipt DownloadApi
  static Future<CommonResponse?> paymentReceiptDownloadApi(
      String sessionId,
      String ledgerId,
      String accId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "bill_id": ledgerId,
        "acc_id": accId,
      };

      final res = await post(data, downloadRecieptUrl, {});
      debugPrint("DownloadApi Response${res?.body}");

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (billDownload): $e");
      return null;
    }
  }

  /// pay_amount
  static Future<PayAmountResponse?> payAmountApi(
      String sessionId,
      String empId,
      String ammount,
      String refType,
      String refId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "acc_id": empId,
        "amount": ammount,
        "ref_type": refType,
        "ref_id": refId,
      };

      final res = await post(data, payAmountUrl, {});
      debugPrint("PayAmount Response ${res?.body}");

      if (res != null) {
        return PayAmountResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (payAmountApi): $e");
      return null;
    }
  }

  /// Fetch or get_payment_status
  static Future<PaymentStatusResponse?> getPaymentStatusApi(
      String sessionId,
      String empId,
      String razorpayOrderId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "razorpay_order_id": razorpayOrderId,
      };

      final res = await post(data, getPaymentStatusUrl, {});

      if (res != null) {
        return PaymentStatusResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (getPaymentStatusApi): $e");
      return null;
    }
  }



//___________________________________Help and Complaints

  /// fetch Complaint list Api
  static Future<ComplaintListResponse?> fetchComplaintsListApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, complaintListUrl, {});

      debugPrint("Transaction response: ${res?.body}");

      if (res != null) {
        return ComplaintListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint list API Error: $e");
      return null;
    }
  }
/// add Complaints Api
  static Future<CommonResponse?> addComplaintApi(
      String accId,
      String sessionId,
      String genId,
      String categoryId,
      String descriptionId,
      String note,
      String typeId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "gen_id": genId,
        "category_id": categoryId,
        "description_id": descriptionId,
        "note": note,
        "type_id": typeId,
      };
      final res = await post(data, addComplaintUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Add Complaint API Error: $e");
      return null;
    }
  }

/// Generator list help Api calling
  static Future<GeneratorListResponse?> addGeneratorListApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, generatorListUrl, {});

      if (res != null) {
        return GeneratorListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Generator list API Error: $e");
      return null;
    }
  }

  /// Add complain dropdowns list
  static Future<DropDownsListResponse?> dropdownsListApi(
      String accId,
      String sessionId,
      String genId,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "gen_id": genId,
      };
      final res = await post(data, complaintDropdownsUrl, {});

      if (res != null) {
        return DropDownsListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint dropdown list API Error: $e");
      return null;
    }
  }

  /// Get int touch list  Api calling
  static Future<GetInTouchListResponse?> fetchGetInTouchListApi(
      String accId,
      String sessionId,
      ) async {
    debugPrint("#########Get in touch Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, getInTouchListUrl, {});

      if (res != null) {
        return GetInTouchListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Get in touch list API Error: $e");
      return null;
    }
  }

  //
  // /// pay_amount
  // static Future<PayAmountResponse?> payAmountApi(
  //     String sessionId,
  //     String empId,
  //     String ammount,
  //     String refType,
  //     String refId,
  //     ) async {
  //   try {
  //     Map<String, String> data = {
  //       "session_id": sessionId,
  //       "acc_id": empId,
  //       "amount": ammount,
  //       "ref_type": refType,
  //       "ref_id": refId,
  //     };
  //
  //     final res = await post(data, payAmountUrl, {});
  //     debugPrint("PayAmount Response ${res?.body}");
  //
  //     if (res != null) {
  //       return PayAmountResponse.fromJson(jsonDecode(res.body));
  //     } else {
  //       debugPrint("Null Response");
  //       return null;
  //     }
  //   } catch (e) {
  //     debugPrint("❌ API Error (payAmountApi): $e");
  //     return null;
  //   }
  // }
  //
  static Future<generatorDetailsResponse?> generatorDetailsAPI(
      String accId,
      String sessionId,
      genId
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        'gen_id':genId
      };
      final res = await post(data, generatorDetailsUrl, {});

      if (res != null) {
        print(res.body);
        return generatorDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Dashboard API Error: $e");
      return null;
    }
  }

  static Future<scheduleListResponse?> scheduleListAPI(
      String accId,
      String sessionId,
      gen_id
      ) async {
    debugPrint("###############################Transaction Api calling ");
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "gen_id": gen_id,
      };
      final res = await post(data, scheduleListUrl, {});
      print(data);
      if (res != null) {
        return scheduleListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Dashboard API Error: $e");
      return null;
    }
  }

  static Future<quotationListResponse?> quotationListAPI(
      String accId,
      String sessionId,
      genID
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "gen_id": genID,
      };
      final res = await post(data, quotationListUrl, {});

      if (res != null) {
        return quotationListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Dashboard API Error: $e");
      return null;
    }
  }

  static Future<complaintListResponse?> complaintListAPI(
      String accId,
      String sessionId,
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
      };
      final res = await post(data, complaintListUrl, {});
      print(res!.body);
      if (res != null) {
        return complaintListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Dashboard API Error: $e");
      return null;
    }
  }

  static Future<amcQuotationListResponse?> amcQuoteListAPI(
      String accId,
      String sessionId,
      genID
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "gen_id": genID,
      };
      final res = await post(data, amcQuoteListUrl, {});

      if (res != null) {
        return amcQuotationListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Dashboard API Error: $e");
      return null;
    }
  }

  static Future<complaintDetailsResponse?> complaintDetailsAPI(
      String accId,
      String sessionId,
      complaintId
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "complaint_id": complaintId,
      };
       print(data);
      final res = await post(data, complaintDetailsUrl, {});

      if (res != null) {
        print(res.body);
        return complaintDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint API Error: $e");
      return null;
    }
  }
  static Future<allJobCardListResponse?> jobCardsListAPI(
      String accId,
      String sessionId,
      complaintId
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "complaint_id": complaintId,
      };
       print(data);
      final res = await post(data, allJobCardsListUrl, {});

      if (res != null) {
        print(res.body);
        return allJobCardListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint API Error: $e");
      return null;
    }
  }

  static Future<allServiceListResponse?> serviceListAPI(
      String accId,
      String sessionId,
      complaintId
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "complaint_id": complaintId,
      };
       print(data);
      final res = await post(data, allServiceListUrl, {});

      if (res != null) {
        print(res.body);
        return allServiceListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint API Error: $e");
      return null;
    }
  }

  static Future<jobCardProductsResponse?> jobCardProductDetailsAPI(
      String accId,
      String sessionId,
      jobCardId
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "job_card_id": jobCardId,
      };
       print(data);
      final res = await post(data, jobCardProductsUrl, {});

      if (res != null) {
        print(res.body);
        return jobCardProductsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint API Error: $e");
      return null;
    }
  }

  static Future<ratingResponse?> updateTechRatingAPI(
      String accId,
      String sessionId,
      complaintId,
      rating
      ) async {
    try {
      Map<String, String> data = {
        "acc_id": accId,
        "session_id": sessionId,
        "complaint_id": complaintId,
        "rating":rating.toString()
      };
       print(data);
      final res = await post(data, updateTechRatingUrl, {});

      if (res != null) {
        print(res.body);
        return ratingResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ Complaint API Error: $e");
      return null;
    }
  }

}
