import 'package:flutter/foundation.dart';
import 'package:gen_service/Models/amcQuotationListResponse.dart';
import 'package:gen_service/Models/complaintListResponse.dart';
import 'package:gen_service/Models/generatorDetailsResponse.dart';
import 'package:gen_service/Models/quotationListResponse.dart';
import 'package:gen_service/Models/scheduleListResponse.dart';

import '../Services/api_calling.dart';

class Generatordetailsprovider extends ChangeNotifier{

  generatorDetailsResponse? _detailsResponse;
  scheduleListResponse? _scheduleResponse;
  quotationListResponse? _quotationResponse;
  complaintListResponse? _complaintResponse;
  amcQuotationListResponse? _amcQuotationResponse;
  bool _isLoading = false;
  String? _errorMessage;

  bool _showMoreDetails = false;

  generatorDetailsResponse? get detailsResponse => _detailsResponse;
  scheduleListResponse? get scheduleResponse => _scheduleResponse;
  quotationListResponse? get quotationResponse => _quotationResponse;
  complaintListResponse? get complaintResponse => _complaintResponse;
  amcQuotationListResponse? get amcQuotationResponse => _amcQuotationResponse;

  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;
  bool get showMoreDetails => _showMoreDetails;

  set showMoreDetails(bool value) {
    _showMoreDetails = value;
    notifyListeners();
  }



  Future<void> fetchGeneratorDetails(String accId, String sessionId,genId) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();
    try {
      final response = await ApiCalling.generatorDetailsAPI(accId, sessionId,genId);

      if (response != null) {
        if (response.error == "0") {
          _detailsResponse = response;
        } else {
          _errorMessage = response.message ?? "Something went wrong!";
        }
      } else {
        _errorMessage = "No response from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch dashboard: $e";
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  Future<void> fetchScheduleList(String accId, String sessionId,gen_id) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();
    try {
      final response = await ApiCalling.scheduleListAPI(accId, sessionId,gen_id);

      if (response != null) {
        if (response.error == "0") {
          _scheduleResponse = response;
          notifyListeners();
        } else {
          _errorMessage = response.message ?? "Something went wrong!";
        }
      } else {
        _errorMessage = "No response from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch dashboard: $e";
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  Future<void> fetchQuotationList(String accId, String sessionId,genID) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();
    try {
      final response = await ApiCalling.quotationListAPI(accId, sessionId,genID);

      if (response != null) {
        if (response.error == "0") {
          _quotationResponse = response;
          notifyListeners();
        } else {
          _errorMessage = response.message ?? "Something went wrong!";
        }
      } else {
        _errorMessage = "No response from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch dashboard: $e";
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  Future<void> fetchComplaintList(String accId, String sessionId) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();
    try {
      final response = await ApiCalling.complaintListAPI(accId, sessionId);

      if (response != null) {
        if (response.error == "0") {
          _complaintResponse = response;
          notifyListeners();
        } else {
          _errorMessage = response.message ?? "Something went wrong!";
        }
      } else {
        _errorMessage = "No response from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch dashboard: $e";
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

  Future<void> fetchAmcQuotationList(String accId, String sessionId,genId) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();
    try {
      final response = await ApiCalling.amcQuoteListAPI(accId, sessionId,genId);

      if (response != null) {
        if (response.error == "0") {
          _amcQuotationResponse = response;
          notifyListeners();
        } else {
          _errorMessage = response.message ?? "Something went wrong!";
        }
      } else {
        _errorMessage = "No response from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to fetch dashboard: $e";
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

}