class generatorDetailsResponse {
  String? error;
  String? message;
  String? id;
  String? hashId;
  String? engine;
  String? prodName;
  String? prodImg;
  String? amc;
  String? warranty;
  GenDetails? genDetails;
  LocationDetails? locationDetails;
  List<Schedule>? schedule;
  List<Quotations>? quotations;
  List<AmcQuotations>? amcQuotations;
  List<Complaints>? complaints;

  generatorDetailsResponse(
      {this.error,
        this.message,
        this.id,
        this.hashId,
        this.engine,
        this.prodName,
        this.prodImg,
        this.amc,
        this.warranty,
        this.genDetails,
        this.locationDetails,
        this.schedule,
        this.quotations,
        this.amcQuotations,
        this.complaints});

  generatorDetailsResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    id = json['id'];
    hashId = json['hash_id'];
    engine = json['engine'];
    prodName = json['prod_name'];
    prodImg = json['prod_img'];
    amc = json['amc'];
    warranty = json['warranty'];
    genDetails = json['gen_details'] != null
        ? new GenDetails.fromJson(json['gen_details'])
        : null;
    locationDetails = json['location_details'] != null
        ? new LocationDetails.fromJson(json['location_details'])
        : null;
    if (json['schedule'] != null) {
      schedule = <Schedule>[];
      json['schedule'].forEach((v) {
        schedule!.add(new Schedule.fromJson(v));
      });
    }
    if (json['quotations'] != null) {
      quotations = <Quotations>[];
      json['quotations'].forEach((v) {
        quotations!.add(new Quotations.fromJson(v));
      });
    }
    if (json['amc_quotations'] != null) {
      amcQuotations = <AmcQuotations>[];
      json['amc_quotations'].forEach((v) {
        amcQuotations!.add(new AmcQuotations.fromJson(v));
      });
    }
    if (json['complaints'] != null) {
      complaints = <Complaints>[];
      json['complaints'].forEach((v) {
        complaints!.add(new Complaints.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['id'] = this.id;
    data['hash_id'] = this.hashId;
    data['engine'] = this.engine;
    data['prod_name'] = this.prodName;
    data['prod_img'] = this.prodImg;
    data['amc'] = this.amc;
    data['warranty'] = this.warranty;
    if (this.genDetails != null) {
      data['gen_details'] = this.genDetails!.toJson();
    }
    if (this.locationDetails != null) {
      data['location_details'] = this.locationDetails!.toJson();
    }
    if (this.schedule != null) {
      data['schedule'] = this.schedule!.map((v) => v.toJson()).toList();
    }
    if (this.quotations != null) {
      data['quotations'] = this.quotations!.map((v) => v.toJson()).toList();
    }
    if (this.amcQuotations != null) {
      data['amc_quotations'] =
          this.amcQuotations!.map((v) => v.toJson()).toList();
    }
    if (this.complaints != null) {
      data['complaints'] = this.complaints!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class GenDetails {
  String? purchaseDate;
  String? altNo;
  String? modelName;
  String? batterNo;
  String? commisDate;
  String? dispDate;

  GenDetails(
      {this.purchaseDate,
        this.altNo,
        this.modelName,
        this.batterNo,
        this.commisDate,
        this.dispDate});

  GenDetails.fromJson(Map<String, dynamic> json) {
    purchaseDate = json['purchase_date'];
    altNo = json['alt_no'];
    modelName = json['model_name'];
    batterNo = json['batter_no'];
    commisDate = json['commis_date'];
    dispDate = json['disp_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['purchase_date'] = this.purchaseDate;
    data['alt_no'] = this.altNo;
    data['model_name'] = this.modelName;
    data['batter_no'] = this.batterNo;
    data['commis_date'] = this.commisDate;
    data['disp_date'] = this.dispDate;
    return data;
  }
}

class LocationDetails {
  String? stateName;
  String? districtName;
  String? address;

  LocationDetails({this.stateName, this.districtName, this.address});

  LocationDetails.fromJson(Map<String, dynamic> json) {
    stateName = json['state_name'];
    districtName = json['district_name'];
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['state_name'] = this.stateName;
    data['district_name'] = this.districtName;
    data['address'] = this.address;
    return data;
  }
}

class Schedule {
  String? id;
  String? date;
  String? type;
  String? complaintType;
  String? reason;
  String? status;
  String? amc;
  String? warranty;

  Schedule(
      {this.id,
        this.date,
        this.type,
        this.complaintType,
        this.reason,
        this.status,
        this.amc,
        this.warranty,
      });

  Schedule.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    date = json['date'];
    type = json['type'];
    complaintType = json['complaint_type'];
    reason = json['reason'];
    status = json['status'];
    amc = json['amc'];
    warranty = json['warranty'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['date'] = this.date;
    data['type'] = this.type;
    data['complaint_type'] = this.complaintType;
    data['reason'] = this.reason;
    data['status'] = this.status;
    data['amc'] = this.amc;
    data['warranty'] = this.warranty;
    return data;
  }
}

class Quotations {
  String? id;
  String? title;
  String? filePath;
  String? date;

  Quotations({this.id, this.title, this.filePath, this.date});

  Quotations.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    title = json['title'];
    filePath = json['file_path'];
    date = json['date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['title'] = this.title;
    data['file_path'] = this.filePath;
    data['date'] = this.date;
    return data;
  }
}

class AmcQuotations {
  String? id;
  String? noOfVisits;
  String? price;
  String? amcStatus;
  String? expNote;
  String? noOfOilServices;
  String? purchaseDate;

  AmcQuotations(
      {this.id,
        this.noOfVisits,
        this.price,
        this.amcStatus,
        this.expNote,
        this.noOfOilServices,
        this.purchaseDate});

  AmcQuotations.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    noOfVisits = json['no_of_visits'];
    price = json['price'];
    amcStatus = json['amc_status'];
    expNote = json['exp_note'];
    noOfOilServices = json['no_of_oil_services'];
    purchaseDate = json['purchase_Date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['no_of_visits'] = this.noOfVisits;
    data['price'] = this.price;
    data['amc_status'] = this.amcStatus;
    data['exp_note'] = this.expNote;
    data['no_of_oil_services'] = this.noOfOilServices;
    data['purchase_Date'] = this.purchaseDate;
    return data;
  }
}

class Complaints {
  String? id;
  String? openStatus;
  String? modelName;
  String? registredDate;
  String? hashId;
  String? productName;
  String? complaintName;

  Complaints(
      {this.id,
        this.openStatus,
        this.modelName,
        this.registredDate,
        this.hashId,
        this.productName,
        this.complaintName});

  Complaints.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    openStatus = json['open_status'];
    modelName = json['model_name'];
    registredDate = json['registred_date'];
    hashId = json['hash_id'];
    productName = json['product_name'];
    complaintName = json['complaint_name'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['open_status'] = this.openStatus;
    data['model_name'] = this.modelName;
    data['registred_date'] = this.registredDate;
    data['hash_id'] = this.hashId;
    data['product_name'] = this.productName;
    data['complaint_name'] = this.complaintName;
    return data;
  }
}
