class complaintDetailsResponse {
  String? error;
  List<ComplaintDetails>? complaintDetails;
  List<JobCardList>? jobCardList;
  List<ServiceDetails>? serviceDetails;
  String? message;
  String? sessionExists;

  complaintDetailsResponse(
      {this.error,
        this.complaintDetails,
        this.jobCardList,
        this.serviceDetails,
        this.message,
        this.sessionExists});

  complaintDetailsResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['complaint_details'] != null) {
      complaintDetails = <ComplaintDetails>[];
      json['complaint_details'].forEach((v) {
        complaintDetails!.add(new ComplaintDetails.fromJson(v));
      });
    }
    if (json['job_card_list'] != null) {
      jobCardList = <JobCardList>[];
      json['job_card_list'].forEach((v) {
        jobCardList!.add(new JobCardList.fromJson(v));
      });
    }
    if (json['service_details'] != null) {
      serviceDetails = <ServiceDetails>[];
      json['service_details'].forEach((v) {
        serviceDetails!.add(new ServiceDetails.fromJson(v));
      });
    }
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.complaintDetails != null) {
      data['complaint_details'] =
          this.complaintDetails!.map((v) => v.toJson()).toList();
    }
    if (this.jobCardList != null) {
      data['job_card_list'] = this.jobCardList!.map((v) => v.toJson()).toList();
    }
    if (this.serviceDetails != null) {
      data['service_details'] =
          this.serviceDetails!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class ComplaintDetails {
  String? id;
  String? openStatus;
  String? registredDate;
  String? hashId;
  String? productName;
  String? complaintName;
  String? complaintDesc;
  String? complaintNote;

  ComplaintDetails(
      {this.id,
        this.openStatus,
        this.registredDate,
        this.hashId,
        this.productName,
        this.complaintName,
        this.complaintDesc,
        this.complaintNote});

  ComplaintDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    openStatus = json['open_status'];
    registredDate = json['registred_date'];
    hashId = json['hash_id'];
    productName = json['product_name'];
    complaintName = json['complaint_name'];
    complaintDesc = json['complaint_desc'];
    complaintNote = json['complaint_note'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['open_status'] = this.openStatus;
    data['registred_date'] = this.registredDate;
    data['hash_id'] = this.hashId;
    data['product_name'] = this.productName;
    data['complaint_name'] = this.complaintName;
    data['complaint_desc'] = this.complaintDesc;
    data['complaint_note'] = this.complaintNote;
    return data;
  }
}

class JobCardList {
  String? id;
  String? complaintId;
  String? extraDescription;
  String? date;
  String? totalPrice;

  JobCardList(
      {this.id,
        this.complaintId,
        this.extraDescription,
        this.date,
        this.totalPrice});

  JobCardList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    complaintId = json['complaint_id'];
    extraDescription = json['extra_description'];
    date = json['date'];
    totalPrice = json['total_price'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['complaint_id'] = this.complaintId;
    data['extra_description'] = this.extraDescription;
    data['date'] = this.date;
    data['total_price'] = this.totalPrice;
    return data;
  }
}

class ServiceDetails {
  String? id;
  String? empName;
  String? lat;
  String? lng;
  String? paymentStatus;
  String? date;
  String? techRoleName;
  String? mobNum;
  String? profileImg;
  String? feedback;
  String? openStatus;
  String? rating;
  String? inOrOutTime;
  String? runningHrs;
  String? fsrExt;
  String? fsrNo;

  ServiceDetails(
      {this.id,
        this.empName,
        this.lat,
        this.lng,
        this.paymentStatus,
        this.date,
        this.techRoleName,
        this.mobNum,
        this.profileImg,
        this.feedback,
        this.openStatus,
        this.rating,
        this.inOrOutTime,
        this.runningHrs,
        this.fsrExt,
        this.fsrNo});

  ServiceDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    empName = json['emp_name'];
    lat = json['lat'];
    lng = json['lng'];
    paymentStatus = json['payment_status'];
    date = json['date'];
    techRoleName = json['tech_role_name'];
    mobNum = json['mob_num'];
    profileImg = json['profile_img'];
    feedback = json['feedback'];
    openStatus = json['open_status'];
    rating = json['rating'];
    inOrOutTime = json['in_or_out_time'];
    runningHrs = json['running_hrs'];
    fsrExt = json['fsr_ext'];
    fsrNo = json['fsr_no'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['emp_name'] = this.empName;
    data['lat'] = this.lat;
    data['lng'] = this.lng;
    data['payment_status'] = this.paymentStatus;
    data['date'] = this.date;
    data['tech_role_name'] = this.techRoleName;
    data['mob_num'] = this.mobNum;
    data['profile_img'] = this.profileImg;
    data['feedback'] = this.feedback;
    data['open_status'] = this.openStatus;
    data['rating'] = this.rating;
    data['in_or_out_time'] = this.inOrOutTime;
    data['running_hrs'] = this.runningHrs;
    data['fsr_ext'] = this.fsrExt;
    data['fsr_no'] = this.fsrNo;
    return data;
  }
}
