class jobCardProductsResponse {
  String? error;
  List<JobCardProducts>? jobCardProducts;
  String? message;

  jobCardProductsResponse({this.error, this.jobCardProducts, this.message});

  jobCardProductsResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['job_card_products'] != null) {
      jobCardProducts = <JobCardProducts>[];
      json['job_card_products'].forEach((v) {
        jobCardProducts!.add(new JobCardProducts.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.jobCardProducts != null) {
      data['job_card_products'] =
          this.jobCardProducts!.map((v) => v.toJson()).toList();
    }
    data['message'] = this.message;
    return data;
  }
}

class JobCardProducts {
  String? id;
  String? partName;
  String? qty;
  String? price;
  String? totalPrice;

  JobCardProducts(
      {this.id, this.partName, this.qty, this.price, this.totalPrice});

  JobCardProducts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    partName = json['part_name'];
    qty = json['qty'];
    price = json['price'];
    totalPrice = json['total_price'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['part_name'] = this.partName;
    data['qty'] = this.qty;
    data['price'] = this.price;
    data['total_price'] = this.totalPrice;
    return data;
  }
}
