import 'package:flutter/material.dart';

class SectionHeading extends StatelessWidget {
  final String title;
  final TextStyle? textStyle;
  final EdgeInsetsGeometry padding;

  const SectionHeading({
    Key? key,
    required this.title,
    this.textStyle = const TextStyle(fontSize: 14, fontWeight: FontWeight.w500, fontFamily: "Poppins"),
    this.padding = const EdgeInsets.symmetric(horizontal: 8, vertical: 2),
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: padding,
      child: Text(
        title,
        style: textStyle ??
            Theme.of(context).textTheme.titleMedium?.copyWith(
              fontWeight: FontWeight.bold,
            ),
      ),
    );
  }
}
