import 'dart:io';

import 'package:flutter/cupertino.dart';
import 'package:http/http.dart' as http;

Future<http.Response?> post(
  Map<String, dynamic> Body,
  apiUrl,
  Map<String, String> Headers,
) async {
  http.Response? response;
  try {
    response = await http.post(Uri.parse(apiUrl), headers: Headers, body: Body);
    return response;
  } on Exception catch (e, s) {
    print(e);
    print(s);
  }
  return response;
}

Future<http.Response?> get(apiUrl, Map<String, String> Headers) async {
  http.Response? response;
  try {
    response = await http.get(Uri.parse(apiUrl), headers: Headers);
    return response;
  } on Exception catch (e, s) {
    print(e);
    print(s);
  }
  return response;
}

Future<String?> postImage(
  Map<String, String> body,
  String urlLink,
  Map<String, String> headers,
  File image,
) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers);
    req.files.add(
      await http.MultipartFile.fromPath('check_in_pic', image.path),
    );
    req.fields.addAll(body);

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** $resBody .... $res");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint(e.toString());
    return null;
  }
}

Future<String?> postImage2(
  Map<String, String> body,
  Map<String, String> headers,
  String urlLink,
  File image,
) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers);
    req.files.add(
      await http.MultipartFile.fromPath('check_out_pic', image.path),
    );
    req.fields.addAll(body);

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** $resBody .... $res");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint(e.toString());
    return null;
  }
}

Future<String?> postImage3(
  Map<String, String> body,
  Map<String, String> headers,
  String urlLink,
  File image,
) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers);
    req.files.add(
      await http.MultipartFile.fromPath('payment_proof', image.path),
    );
    req.fields.addAll(body);

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** $resBody .... $res");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint(e.toString());
    return null;
  }
}

Future<String?> postImage4(
  Map<String, String> body,
  Map<String, String> headers,
  String urlLink,
  File image,
) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers);
    req.files.add(await http.MultipartFile.fromPath('fsr_file', image.path));
    req.fields.addAll(body);

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** $resBody .... ${res.statusCode}");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint(e.toString());
    return null;
  }
}

Future<String?> postImageNew(
  Map<String, String> body,
  Map<String, String> headers,
  String urlLink,
  File image,
  reqField,
) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers ?? {});
    req.files.add(await http.MultipartFile.fromPath(reqField, image.path));
    req.fields.addAll(body ?? {});

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** $resBody .... ${res.statusCode}");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint(e.toString());
    return null;
  }
}
//travel_image
//hotel_image
//other_image

// Future<String?> PostMultipleImagesNew(
//   Map<String, String> body,
//   String urlLink,
//   Map<String, String> headers,
//   List<http.MultipartFile> newList,
//   List<http.MultipartFile> newList1,
//   List<http.MultipartFile> newList2,
// ) async {
//   try {
//     var req = http.MultipartRequest('POST', Uri.parse(urlLink));
//     req.headers.addAll(headers);
//     req.files.addAll(newList);
//     req.files.addAll(newList1);
//     req.files.addAll(newList2);
//     req.fields.addAll(body);
//
//     var res = await req.send();
//     final resBody = await res.stream.bytesToString();
//
//     if (res.statusCode >= 200 && res.statusCode < 300) {
//       print("**** $resBody .... $res");
//       return resBody;
//     } else {
//       print("error: ${res.reasonPhrase}");
//       return null;
//     }
//   } catch (e) {
//     debugPrint(e.toString());
//     return null;
//   }
// }

Future<String?> PostMultipleImagesNew2(
  Map<String, String> body,
  String urlLink,
  Map<String, String> headers,
  List<http.MultipartFile> newList,
  List<http.MultipartFile> newList1,
) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers);
    req.files.addAll(newList);
    req.files.addAll(newList1);
    req.fields.addAll(body);

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** $resBody .... $res");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint(e.toString());
    return null;
  }
}

Future<String?> PostMultipleImages(
  Map<String, String> body,
  String urlLink,
  Map<String, String> headers,
  List<http.MultipartFile> newList,
) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers);
    req.files.addAll(newList);
    req.fields.addAll(body);

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** $resBody .... $res");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint(e.toString());
    return null;
  }
}
Future<String?> PostMultipleImagesNew(
    Map<String, String> body,
    String urlLink,
    Map<String, String> headers,
    List<http.MultipartFile> newList) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers);
    req.files.addAll(newList);
    req.fields.addAll(body);

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** $resBody .... $res");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint(e.toString());
    return null;
  }
}


/// Send message with multiple images
Future<String?> postMessageWithImages(
    Map<String, String> body,
    String urlLink,
    Map<String, String> headers,
    List<File> images,
    ) async {
  try {
    var req = http.MultipartRequest('POST', Uri.parse(urlLink));
    req.headers.addAll(headers);

    // Add all images with the key 'images[]'
    for (var image in images) {
      if (await image.exists()) {
        req.files.add(
          await http.MultipartFile.fromPath('images[]', image.path),
        );
      }
    }

    req.fields.addAll(body);

    var res = await req.send();
    final resBody = await res.stream.bytesToString();

    if (res.statusCode >= 200 && res.statusCode < 300) {
      print("**** Message sent successfully: $resBody");
      return resBody;
    } else {
      print("error: ${res.reasonPhrase}");
      return null;
    }
  } catch (e) {
    debugPrint("Error sending message with images: $e");
    return null;
  }
}
