class TransactionsResponse {
  int? balanceAmount;
  String? creditAmount;
  String? debitAmount;
  Map<String, List<TransactionItem>>? transactions;
  String? error;
  String? message;

  TransactionsResponse({
    this.balanceAmount,
    this.creditAmount,
    this.debitAmount,
    this.transactions,
    this.error,
    this.message,
  });

  TransactionsResponse.fromJson(Map<String, dynamic> json) {
    balanceAmount = json['balance_amount'];
    creditAmount = json['credit_amount'];
    debitAmount = json['debit_amount'];
    error = json['error'];
    message = json['message'];

    if (json['transactions'] != null) {
      transactions = {};
      json['transactions'].forEach((key, value) {
        transactions![key] = (value as List)
            .map((v) => TransactionItem.fromJson(v))
            .toList();
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = {};
    data['balance_amount'] = balanceAmount;
    data['credit_amount'] = creditAmount;
    data['debit_amount'] = debitAmount;
    data['error'] = error;
    data['message'] = message;

    if (transactions != null) {
      data['transactions'] = transactions!.map((key, value) =>
          MapEntry(key, value.map((v) => v.toJson()).toList()));
    }
    return data;
  }
}

class TransactionItem {
  String? paymentId;
  String? amount;
  String? type;
  String? purpose;
  String? date;

  TransactionItem({
    this.paymentId,
    this.amount,
    this.type,
    this.purpose,
    this.date,
  });

  TransactionItem.fromJson(Map<String, dynamic> json) {
    paymentId = json['payment_id'];
    amount = json['amount'];
    type = json['type'];
    purpose = json['purpose'];
    date = json['date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = {};
    data['payment_id'] = paymentId;
    data['amount'] = amount;
    data['type'] = type;
    data['purpose'] = purpose;
    data['date'] = date;
    return data;
  }
}
