class PaymentReceiptDetailsResponse {
  int? error;
  ReceiptDetails? receiptDetails;
  String? message;
  int? sessionExists;

  PaymentReceiptDetailsResponse(
      {this.error, this.receiptDetails, this.message, this.sessionExists});

  PaymentReceiptDetailsResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    receiptDetails = json['receipt_details'] != null
        ? new ReceiptDetails.fromJson(json['receipt_details'])
        : null;
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.receiptDetails != null) {
      data['receipt_details'] = this.receiptDetails!.toJson();
    }
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class ReceiptDetails {
  String? id;
  String? accId;
  String? billId;
  String? narration;
  String? cAmount;
  String? dAmount;
  String? atype;
  String? type;
  String? mode;
  String? refNo;
  String? empId;
  String? datetime;
  String? prDate;
  String? depositedTo;
  String? delEmp;
  String? delDatetime;
  String? isExist;
  String? isJv;

  ReceiptDetails(
      {this.id,
        this.accId,
        this.billId,
        this.narration,
        this.cAmount,
        this.dAmount,
        this.atype,
        this.type,
        this.mode,
        this.refNo,
        this.empId,
        this.datetime,
        this.prDate,
        this.depositedTo,
        this.delEmp,
        this.delDatetime,
        this.isExist,
        this.isJv});

  ReceiptDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    accId = json['acc_id'];
    billId = json['bill_id'];
    narration = json['narration'];
    cAmount = json['c_amount'];
    dAmount = json['d_amount'];
    atype = json['atype'];
    type = json['type'];
    mode = json['mode'];
    refNo = json['ref_no'];
    empId = json['emp_id'];
    datetime = json['datetime'];
    prDate = json['pr_date'];
    depositedTo = json['deposited_to'];
    delEmp = json['del_emp'];
    delDatetime = json['del_datetime'];
    isExist = json['is_exist'];
    isJv = json['is_jv'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['acc_id'] = this.accId;
    data['bill_id'] = this.billId;
    data['narration'] = this.narration;
    data['c_amount'] = this.cAmount;
    data['d_amount'] = this.dAmount;
    data['atype'] = this.atype;
    data['type'] = this.type;
    data['mode'] = this.mode;
    data['ref_no'] = this.refNo;
    data['emp_id'] = this.empId;
    data['datetime'] = this.datetime;
    data['pr_date'] = this.prDate;
    data['deposited_to'] = this.depositedTo;
    data['del_emp'] = this.delEmp;
    data['del_datetime'] = this.delDatetime;
    data['is_exist'] = this.isExist;
    data['is_jv'] = this.isJv;
    return data;
  }
}
