class SubscribeOrderDetailsResponse {
  String? orderid;
  String? orderNum;
  String? rentedDate;
  String? fromDate;
  String? toDate;
  String? accName;
  String? adress;
  String? expiringInColor;
  String? expiringText;
  List<Products>? products;
  List<PurchasedItm>? purchasedItm;
  String? error;
  String? message;

  SubscribeOrderDetailsResponse(
      {this.orderid,
        this.orderNum,
        this.rentedDate,
        this.fromDate,
        this.toDate,
        this.accName,
        this.adress,
        this.expiringInColor,
        this.expiringText,
        this.products,
        this.purchasedItm,
        this.error,
        this.message});

  SubscribeOrderDetailsResponse.fromJson(Map<String, dynamic> json) {
    orderid = json['orderid'];
    orderNum = json['order_num'];
    rentedDate = json['rentedDate'];
    fromDate = json['from_date'];
    toDate = json['to_date'];
    accName = json['acc_name'];
    adress = json['adress'];
    expiringInColor = json['ExpiringInColor'];
    expiringText = json['expiringText'];
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(new Products.fromJson(v));
      });
    }
    if (json['purchased_itm'] != null) {
      purchasedItm = <PurchasedItm>[];
      json['purchased_itm'].forEach((v) {
        purchasedItm!.add(new PurchasedItm.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['orderid'] = this.orderid;
    data['order_num'] = this.orderNum;
    data['rentedDate'] = this.rentedDate;
    data['from_date'] = this.fromDate;
    data['to_date'] = this.toDate;
    data['acc_name'] = this.accName;
    data['adress'] = this.adress;
    data['ExpiringInColor'] = this.expiringInColor;
    data['expiringText'] = this.expiringText;
    if (this.products != null) {
      data['products'] = this.products!.map((v) => v.toJson()).toList();
    }
    if (this.purchasedItm != null) {
      data['purchased_itm'] =
          this.purchasedItm!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Products {
  String? id;
  String? idName;
  String? prodName;
  String? totalPrice;
  String? per;
  String? dispatchDate;
  String? receivedDate;

  Products(
      {this.id,
        this.idName,
        this.prodName,
        this.totalPrice,
        this.per,
        this.dispatchDate,
        this.receivedDate});

  Products.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    idName = json['id_name'];
    prodName = json['prod_name'];
    totalPrice = json['total_price'];
    per = json['per'];
    dispatchDate = json['dispatch_date'];
    receivedDate = json['received_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['id_name'] = this.idName;
    data['prod_name'] = this.prodName;
    data['total_price'] = this.totalPrice;
    data['per'] = this.per;
    data['dispatch_date'] = this.dispatchDate;
    data['received_date'] = this.receivedDate;
    return data;
  }
}

class PurchasedItm {
  String? id;
  String? prodName;
  String? qty;
  String? totalPrice;

  PurchasedItm({this.id, this.prodName, this.qty, this.totalPrice});

  PurchasedItm.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    prodName = json['prod_name'];
    qty = json['qty'];
    totalPrice = json['total_price'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['prod_name'] = this.prodName;
    data['qty'] = this.qty;
    data['total_price'] = this.totalPrice;
    return data;
  }
}
