class TicketListResponse {
  final Tickets? tickets;
  final String? error;
  final String? message;

  TicketListResponse({this.tickets, this.error, this.message});

  factory TicketListResponse.fromJson(Map<String, dynamic> json) {
    return TicketListResponse(
      tickets:
      json['tickets'] != null ? Tickets.fromJson(json['tickets']) : null,
      error: json['error']?.toString(),
      message: json['message']?.toString(),
    );
  }

  Map<String, dynamic> toJson() => {
    if (tickets != null) 'tickets': tickets!.toJson(),
    'error': error,
    'message': message,
  };
}

class Tickets {
  final List<TicketItem>? closed;
  final List<TicketItem>? inProgress;

  Tickets({this.closed, this.inProgress});

  factory Tickets.fromJson(Map<String, dynamic> json) {
    return Tickets(
      closed: (json['closed'] as List?)
          ?.map((v) => TicketItem.fromJson(v))
          .toList(),
      inProgress: (json['in_progress'] as List?)
          ?.map((v) => TicketItem.fromJson(v))
          .toList(),
    );
  }

  Map<String, dynamic> toJson() => {
    if (closed != null)
      'closed': closed!.map((v) => v.toJson()).toList(),
    if (inProgress != null)
      'in_progress': inProgress!.map((v) => v.toJson()).toList(),
  };
}

class TicketItem {
  final String? id;
  final String? ticketNumber;
  final String? type;
  final String? date;

  TicketItem({this.id, this.ticketNumber, this.type, this.date});

  factory TicketItem.fromJson(Map<String, dynamic> json) {
    return TicketItem(
      id: json['id']?.toString(),
      ticketNumber: json['ticket_number']?.toString(),
      type: json['type']?.toString(),
      date: json['date']?.toString(),
    );
  }

  Map<String, dynamic> toJson() => {
    'id': id,
    'ticket_number': ticketNumber,
    'type': type,
    'date': date,
  };
}
