class TicketChatDisplayResponse {
  String? status;
  String? ticketId;
  List<FeedBacks>? feedBacks;
  String? error;
  String? message;

  TicketChatDisplayResponse(
      {this.status, this.ticketId, this.feedBacks, this.error, this.message});

  TicketChatDisplayResponse.fromJson(Map<String, dynamic> json) {
    status = json['status'];
    ticketId = json['ticket_id'];
    if (json['feed_backs'] != null) {
      feedBacks = <FeedBacks>[];
      json['feed_backs'].forEach((v) {
        feedBacks!.add(new FeedBacks.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['status'] = this.status;
    data['ticket_id'] = this.ticketId;
    if (this.feedBacks != null) {
      data['feed_backs'] = this.feedBacks!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class FeedBacks {
  String? id;
  String? text;
  List<String>? imgNames;
  List<String>? images;
  String? user;
  String? userName;
  String? createdDatetime;
  String? userImg;

  FeedBacks(
      {this.id,
        this.text,
        this.imgNames,
        this.images,
        this.user,
        this.userName,
        this.createdDatetime});

  FeedBacks.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    text = json['text'];
    imgNames = json['img_names'].cast<String>();
    images = json['images'].cast<String>();
    user = json['user'];
    userName = json['user_name'];
    createdDatetime = json['created_datetime'];
    userImg = json['user_img'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['text'] = this.text;
    data['img_names'] = this.imgNames;
    data['images'] = this.images;
    data['user'] = this.user;
    data['user_name'] = this.userName;
    data['created_datetime'] = this.createdDatetime;
    data['user_img'] = this.userImg;
    return data;
  }
}
