class CommonResponse {
  int? error;
  int? balance;
  String? message;
  String? filePath;

  CommonResponse({this.error, this.balance, this.message});

  CommonResponse.fromJson(Map<String, dynamic> json) {
    error = int.tryParse(json['error']?.toString() ?? '');
    balance = int.tryParse(json['balance']?.toString() ?? '');
    message = json['message']?.toString();
    filePath = json['file_path']?.toString();
  }

  Map<String, dynamic> toJson() {
    return {
      'error': error,
      'balance': balance,
      'message': message,
      'file_path': filePath,
    };
  }
}

