class BillDetailsResponse {
  int? error;
  BillDetails? billDetails;
  String? message;

  BillDetailsResponse({this.error, this.billDetails, this.message});

  BillDetailsResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    billDetails = json['bill_details'] != null
        ? new BillDetails.fromJson(json['bill_details'])
        : null;
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.billDetails != null) {
      data['bill_details'] = this.billDetails!.toJson();
    }
    data['message'] = this.message;
    return data;
  }
}

class BillDetails {
  String? id;
  String? billNumber;
  String? orderId;
  String? narration;
  String? basicPrice;
  String? cgst;
  String? sgst;
  String? igst;
  String? totalPrice;
  String? empId;
  String? billDate;
  String? datetime;
  String? delEmp;
  String? isExist;
  String? remarks;
  String? product;
  String? orderNumber;
  String? billPaid;
  String? paidDate;

  BillDetails(
      {this.id,
        this.billNumber,
        this.orderId,
        this.narration,
        this.basicPrice,
        this.cgst,
        this.sgst,
        this.igst,
        this.totalPrice,
        this.empId,
        this.billDate,
        this.datetime,
        this.delEmp,
        this.isExist,
        this.remarks,
        this.product,
        this.orderNumber,
        this.billPaid,
        this.paidDate});

  BillDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    billNumber = json['bill_number'];
    orderId = json['order_id'];
    narration = json['narration'];
    basicPrice = json['basic_price'];
    cgst = json['cgst'];
    sgst = json['sgst'];
    igst = json['igst'];
    totalPrice = json['total_price'];
    empId = json['emp_id'];
    billDate = json['bill_date'];
    datetime = json['datetime'];
    delEmp = json['del_emp'];
    isExist = json['is_exist'];
    remarks = json['remarks'];
    product = json['product'];
    orderNumber = json['order_number'];
    billPaid = json['bill_paid'];
    paidDate = json['paid_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['bill_number'] = this.billNumber;
    data['order_id'] = this.orderId;
    data['narration'] = this.narration;
    data['basic_price'] = this.basicPrice;
    data['cgst'] = this.cgst;
    data['sgst'] = this.sgst;
    data['igst'] = this.igst;
    data['total_price'] = this.totalPrice;
    data['emp_id'] = this.empId;
    data['bill_date'] = this.billDate;
    data['datetime'] = this.datetime;
    data['del_emp'] = this.delEmp;
    data['is_exist'] = this.isExist;
    data['remarks'] = this.remarks;
    data['product'] = this.product;
    data['order_number'] = this.orderNumber;
    data['bill_paid'] = this.billPaid;
    data['paid_date'] = this.paidDate;
    return data;
  }
}
