import 'package:flutter/material.dart';
import 'package:gen_rentals/Screens/SplashScreen.dart';
import 'package:provider/provider.dart';
import 'Notifier/RentalContactProvider .dart';
import 'Notifier/theme_provider.dart';
import 'Screens/authScreen/LoginScreen.dart';


//  navigatorKey to navigate outside BuildContext
final GlobalKey<NavigatorState> navigatorKey = GlobalKey<NavigatorState>();

// // Initialize the notification plugin
// final FlutterLocalNotificationsPlugin flutterLocalNotificationsPlugin =
// FlutterLocalNotificationsPlugin();

void main() {
  runApp(const MyApp());
}

class MyApp extends StatelessWidget {
  const MyApp({super.key});

  @override
  Widget build(BuildContext context) {
    return MultiProvider(
      providers: [
        ChangeNotifierProvider<RentalContactProvider>(create: (_) => RentalContactProvider(),
        ),
        ChangeNotifierProvider<ThemeProvider>(create: (_) => ThemeProvider(),
        ),
      ],
      child: Consumer<ThemeProvider>(
        builder: (context, themeProvider, child) {
          return MaterialApp(
            debugShowCheckedModeBanner: false,
            title: 'Gen Rentals',
            theme: themeProvider.isDark
                ? ThemeData.dark()
                : ThemeData.light().copyWith(
              scaffoldBackgroundColor: const Color(0xFFF5F8FC),
            ),
            home: const SplashScreen(), //
          );
        },
      ),
    );
  }
}
