class BillDetailsResponse {
  List<BillDetails>? billDetails;
  int? error;
  String? message;

  BillDetailsResponse({this.billDetails, this.error, this.message});

  BillDetailsResponse.fromJson(Map<String, dynamic> json) {
    if (json['bill_details'] != null) {
      billDetails = <BillDetails>[];
      json['bill_details'].forEach((v) {
        billDetails!.add(new BillDetails.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.billDetails != null) {
      data['bill_details'] = this.billDetails!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class BillDetails {
  String? totalAmount;
  String? raisedOn;
  String? billNarration;
  String? billId;
  String? orderId;

  BillDetails(
      {this.totalAmount,
        this.raisedOn,
        this.billNarration,
        this.billId,
        this.orderId});

  BillDetails.fromJson(Map<String, dynamic> json) {
    totalAmount = json['total_amount'];
    raisedOn = json['raised_on'];
    billNarration = json['bill_narration'];
    billId = json['bill_id'];
    orderId = json['order_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['total_amount'] = this.totalAmount;
    data['raised_on'] = this.raisedOn;
    data['bill_narration'] = this.billNarration;
    data['bill_id'] = this.billId;
    data['order_id'] = this.orderId;
    return data;
  }
}
