class OrderListResponse {
  List<Order>? order;
  int? error;
  String? message;

  OrderListResponse({this.order, this.error, this.message});

  OrderListResponse.fromJson(Map<String, dynamic> json) {
    if (json['order'] != null) {
      order = <Order>[];
      json['order'].forEach((v) {
        order!.add(new Order.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.order != null) {
      data['order'] = this.order!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Order {
  String? orderid;
  String? datetime;
  String? address;

  Order({this.orderid, this.datetime, this.address});

  Order.fromJson(Map<String, dynamic> json) {
    orderid = json['orderid'];
    datetime = json['datetime'];
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['orderid'] = this.orderid;
    data['datetime'] = this.datetime;
    data['address'] = this.address;
    return data;
  }
}
