class TicketChatDisplayResponse {
  List<Ticket>? ticket;
  int? error;
  String? message;

  TicketChatDisplayResponse({this.ticket, this.error, this.message});

  TicketChatDisplayResponse.fromJson(Map<String, dynamic> json) {
    if (json['ticket'] != null) {
      ticket = <Ticket>[];
      json['ticket'].forEach((v) {
        ticket!.add(new Ticket.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.ticket != null) {
      data['ticket'] = this.ticket!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Ticket {
  String? tid;
  String? datetime;
  String? msg;
  String? type;

  Ticket({this.tid, this.datetime, this.msg, this.type});

  Ticket.fromJson(Map<String, dynamic> json) {
    tid = json['tid'];
    datetime = json['datetime'];
    msg = json['msg'];
    type = json['type'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tid'] = this.tid;
    data['datetime'] = this.datetime;
    data['msg'] = this.msg;
    data['type'] = this.type;
    return data;
  }
}
